<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
 
// DB table to use
$table = 'sku_price_details';
 
// Table's primary key
$primaryKey = 'id';
 
// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case simple
// indexes
$columns = array(
    array( 'db' => 'vendor_id',  'dt' => 0 ),
	array( 'db' => 'tile',  'dt' => 1 ),
    array( 'db' => 'vendor',  'dt' => 2 ),
    array( 'db' => 'variant_sku',   'dt' => 3 ),
    array(
        'db'        => 'variant_price_inr',
        'dt'        => 4,
        'formatter' => function( $d, $row ) {
            return 'Rs'.number_format($d,2);
        }
    ),
    array(
        'db'        => 'variant_compare_price_inr',
        'dt'        => 5,
        'formatter' => function( $d, $row ) {
            return 'Rs'.number_format($d,2);
        }
    ),
    array(
        'db'        => 'variant_price_usd',
        'dt'        => 6,
        'formatter' => function( $d, $row ) {
            return '$'.number_format($d,2);
        }
    ),
    array(
        'db'        => 'variant_compare_price_usd',
        'dt'        => 7,
        'formatter' => function( $d, $row ) {
            return '$'.number_format($d,2);
        }
    ),
    array( 'db' => 'updated_by',   'dt' => 8 ),
    array( 'db' => 'created_date',   'dt' => 9 ),
    array(
	        'db'        => 'id',
	        'dt'        => 10,
	        'formatter' => function( $d, $row ) {
	            return "<a href='/admin/price/view/".$d."'>View</a>";
	        }
    )
    
);
 
// SQL server connection information
$sql_details = array(
    'user' => 'pksqueak',
    'pass' => 'pk@admin$9',
    'db'   => 'pricecalc',
    'host' => 'localhost'
);
 
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
 
require( 'ssp.class.php' );
 
echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns )
);

?>