<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
 
// DB table to use
$table = 'price_qty_update_details';
 
// Table's primary key
$primaryKey = 'id';
 
// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case simple
// indexes
$columns = array(
    array( 'db' => 'id',  'dt' => 0 ),
    array(
            'db'        => 'image',
            'dt'        => 1,
            'formatter' => function( $d, $row ) {
                return "<img src='".$d."' width='80' height='80' >";
            }
    ),
    array( 'db' => 'product_id',  'dt' => 2 ),
    array( 'db' => 'variant_id',  'dt' => 3 ),
    array(
        'db'        => 'price_old',
        'dt'        => 4,
        'formatter' => function( $d, $row ) {
            return 'Rs '.number_format($d,2);
        }
    ),
    array( 'db' => 'qty_old',  'dt' => 5 ),
    array(
        'db'        => 'price_new',
        'dt'        => 6,
        'formatter' => function( $d, $row ) {
            return 'Rs '.number_format($d,2);
        }
    ),
    array( 'db' => 'qty_new',   'dt' => 7 ),
    array( 'db' => 'created_at',   'dt' => 8 )
    
);
 
// SQL server connection information
$sql_details = array(
    'user' => 'pksqueak',
    'pass' => 'pk@admin$9',
    'db'   => 'pricecalc',
    'host' => 'localhost'
);
 
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
 
require( 'ssp.class.php' );
 
echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns )
);

?>