<?php
define('ENVIRONMENT', 'development');

$ds = DIRECTORY_SEPARATOR;

define('BASEPATH', dirname(dirname(dirname(__FILE__)))."/kptracking/pricecalc");
define('APPPATH', BASEPATH . $ds . 'application' . $ds);
define('LIBBATH', BASEPATH . "{$ds}system{$ds}libraries{$ds}Session{$ds}");

require_once LIBBATH . 'Session_driver.php';
require_once LIBBATH . "drivers{$ds}Session_files_driver.php";
require_once BASEPATH . "{$ds}system{$ds}core{$ds}Common.php";

$config = get_config();

if (empty($config['sess_save_path'])) {
    $config['sess_save_path'] = rtrim(ini_get('session.save_path'), '/\\');
}

$config = array(
    'cookie_lifetime'   => $config['sess_expiration'],
    'cookie_name'       => $config['sess_cookie_name'],
    'cookie_path'       => $config['cookie_path'],
    'cookie_domain'     => $config['cookie_domain'],
    'cookie_secure'     => $config['cookie_secure'],
    'expiration'        => $config['sess_expiration'],
    'match_ip'          => $config['sess_match_ip'],
    'save_path'         => $config['sess_save_path'],
    '_sid_regexp'       => '[0-9a-v]{32}',
);


$class = new CI_Session_files_driver($config);

if (is_php('5.4')) {
    session_set_save_handler($class, TRUE);
} else {
    session_set_save_handler(
        array($class, 'open'),
        array($class, 'close'),
        array($class, 'read'),
        array($class, 'write'),
        array($class, 'destroy'),
        array($class, 'gc')
    );
    register_shutdown_function('session_write_close');
}
session_name($config['cookie_name']);
session_start();
?>

<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
 
// DB table to use
$table = 'price_qty_update_details';
 
// Table's primary key
$primaryKey = 'id';
 
// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case simple
// indexes
$columns = array(
    array( 'db' => 'id',  'dt' => 0 ),
    array(
            'db'        => 'image',
            'dt'        => 1,
            'formatter' => function( $d, $row ) {
                return "<img src='".$d."' width='80' height='80' >";
            }
    ),
    array( 'db' => 'product_id',  'dt' => 2 ),
    array( 'db' => 'variant_id',  'dt' => 3 ),
    array(
        'db'        => 'price_old',
        'dt'        => 4,
        'formatter' => function( $d, $row ) {
            return 'Rs '.number_format($d,2);
        }
    ),
    array( 'db' => 'qty_old',  'dt' => 5 ),
    array(
        'db'        => 'price_new',
        'dt'        => 6,
        'formatter' => function( $d, $row ) {
            return 'Rs '.number_format($d,2);
        }
    ),
    array( 'db' => 'qty_new',   'dt' => 7 ),
    array( 'db' => 'created_at',   'dt' => 8 )
    
);
 
// SQL server connection information
$sql_details = array(
    'user' => 'pksqueak',
    'pass' => 'pk@admin$9',
    'db'   => 'pricecalc',
    'host' => 'localhost'
);
 
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */

$vendor = $_SESSION['vendor_name'];
 
require( 'ssp.class.php' );
 
echo json_encode(
    // SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns )
    SSP::complex( $_GET, $sql_details, $table, $primaryKey, $columns, null, "vendor_name = '".$vendor."'" )
);

?>