<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
 
// DB table to use
$table = 'kp_order_details';
 
// Table's primary key
$primaryKey = 'id';
 
// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case simple
// indexes
$columns = array(

	array( 'db' => 'order_number',  'dt' => 0 ),
    array( 'db' => 'email',  'dt' => 1 ),
    array( 'db' => 'created_at',   'dt' => 2 ),
    array(
        'db'        => 'total_price',
        'dt'        => 3,
        'formatter' => function( $d, $row ) {
            return '$'.number_format($d);
        }
    ),
	array( 'db' => 'gateway',   'dt' => 4 ),
    array( 'db' => 'financial_status',     'dt' => 5 ),
    array(
	        'db'        => 'id',
	        'dt'        => 6,
	        
	        'formatter' => function( $d, $row ) {
	            return "<a href='/admin/orders/view/".$d."'>View & Edit Order</a>";
	        }
			
    ),
	
	    array( 'db' => 'order_status_admin',     'dt' => 7 )

    
);
 
// SQL server connection information
$sql_details = array(
    'user' => 'pksqueak',
    'pass' => 'pk@admin$9',
    'db'   => 'pricecalc',
    'host' => 'localhost'
);
 
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
 
require( 'ssp.class.php' );
 
echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns )
);

?>