<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Orders_model extends CI_Model {

    function getOrderDetails(){
     
        $response = array();
     
        $this->db->from('kp_order_details');
        $this->db->order_by("id","desc");
        $response=$this->db->get();
        return $response->result_array();

    }

    function getPoVendorDetails($id){

        $this->db->select('vendorDetails.*')
             ->from('kp_product_details')
             ->join('vendorDetails', 'kp_product_details.vendor = vendorDetails.vendorName', 'left')
             ->where('kp_product_details.product_id', $id);

        $query = $this->db->get();
        $qry = $query->row_array();
        return $qry;
    }

    
    function getInvoiceDetails($id){

        $this->db->select('*')
             ->from('kp_invoice')
             ->where('order_id', $id);

        $query = $this->db->get();
        $qry = $query->row_array();
        return $qry;
    }

    function updateInvoiceDetails($id){

        $data = [
            'mail' => 1,
        ];
        $this->db->where('id', $id);
        $this->db->update('kp_invoice', $data);

    }

    function insertPoInvoiceDetails($invoiceData){
        $this->db->insert('kp_invoice',$invoiceData);
    }
  
    function getPoSingleOrderDetails($id = 0) {
        if ($id === 0)
        {
            $query = $this->db->get('kp_order_details');
            return $query->result_array();
        }
 
        $query = $this->db->get_where('kp_order_details', array('order_id' => $id));

        // echo "<pre>";print_r($query->row_array());
        
        return $query->row_array();
    }

    function getPoBillingOrderDetails($id = 0) {
        if ($id === 0)
        {
            $query = $this->db->get('kp_billing_details');
            return $query->result_array();
        }
        $query = $this->db->get_where('kp_billing_details', array('order_id' => $id));
        return $query->row_array();
    }

    function getPoShippingOrderDetails($id = 0) {
        if ($id === 0)
        {
            $query = $this->db->get('kp_shipping_details');
            return $query->result_array();
        }

        $query = $this->db->get_where('kp_shipping_details', array('order_id' => $id));
        return $query->row_array();
    }

    function getPoOrderProductDetails($id = 0) {
        //todo: can revamp with join
        if ($id === 0)
        {
            $query = $this->db->get('kp_order_product_details');
            return $query->result_array();
        }

        $this->db->select('*');
        $this->db->from('kp_order_product_details');
        $this->db->where('order_id', $id);
        $query = $this->db->get();
        return $query->result_array();
    }

  	function getSingleOrderDetails($id = 0) {
        if ($id === 0)
        {
            $query = $this->db->get('kp_order_details');
            return $query->result_array();
        }
 
        $query = $this->db->get_where('kp_order_details', array('id' => $id));

        echo "<pre>";print_r($query->row_array());
        
    	return $query->row_array();
    }

    function getBillingOrderDetails($id = 0) {
        if ($id === 0)
        {
            $query = $this->db->get('kp_billing_details');
            return $query->result_array();
        }

		$this->db->select('order_id');
        $queryOrder = $this->db->get_where('kp_order_details', array('id' => $id));
        $order_id = $queryOrder->row_array();

        $query = $this->db->get_where('kp_billing_details', array('order_id' => $order_id['order_id']));


        
    	return $query->row_array();
    }

    function getShippingOrderDetails($id = 0) {
        if ($id === 0)
        {
            $query = $this->db->get('kp_shipping_details');
            return $query->result_array();
        }

        $this->db->select('order_id');
        $queryOrder = $this->db->get_where('kp_order_details', array('id' => $id));
        $order_id = $queryOrder->row_array();

        $query = $this->db->get_where('kp_shipping_details', array('order_id' => $order_id['order_id']));
        
    	return $query->row_array();
    }

    function getTrackingData($order_id = 0)
    {
        $this->db->select('*');
        $result = $this->get_where('kp_order_product_custom_status',array('order_id',$order_id));
        return $result->row_array();
    }

    function getOrderProductDetails($id = 0) {
        if ($id === 0)
        {
            $query = $this->db->get('kp_order_product_details');
            return $query->result_array();
        }

        $this->db->select('order_id');
        $queryOrder = $this->db->get_where('kp_order_details', array('id' => $id));
        $order_id = $queryOrder->row_array();

        //         $query = $this->db->get_where('kp_order_product_details', array('order_id' => $order_id['order_id']));

        $this->db->select('*');
	    $this->db->from('kp_order_product_details');
	    $this->db->where('order_id', $order_id['order_id']);
	    $query = $this->db->get();
        
    	return $query->result_array();
    }



  function getiOrderDetails(){
 
    $response = array(); 
    $this->db->from('ibhejo_order_details');
    $this->db->order_by("id","desc");
    $response=$this->db->get();
    return $response->result_array();

  }

  	function getiSingleOrderDetails($id = 0) {
        if ($id === 0)
        {
            $query = $this->db->get('ibhejo_order_details');
            return $query->result_array();
        }
 
        $query = $this->db->get_where('ibhejo_order_details', array('id' => $id));
        
    	return $query->row_array();
    }

    function getiBillingOrderDetails($id = 0) {
        if ($id === 0)
        {
            $query = $this->db->get('ibhejo_billing_details');
            return $query->result_array();
        }

		$this->db->select('order_id');
        $queryOrder = $this->db->get_where('ibhejo_order_details', array('id' => $id));
        $order_id = $queryOrder->row_array();

        $query = $this->db->get_where('ibhejo_billing_details', array('order_id' => $order_id['order_id']));


        
    	return $query->row_array();
    }

    function getiShippingOrderDetails($id = 0) {
        if ($id === 0)
        {
            $query = $this->db->get('ibhejo_shipping_details');
            return $query->result_array();
        }

        $this->db->select('order_id');
        $queryOrder = $this->db->get_where('ibhejo_order_details', array('id' => $id));
        $order_id = $queryOrder->row_array();

        $query = $this->db->get_where('ibhejo_shipping_details', array('order_id' => $order_id['order_id']));
        
    	return $query->row_array();
    }

    function getiOrderProductDetails($id = 0) {
        if ($id === 0)
        {
            $query = $this->db->get('ibhejo_order_product_details');
            return $query->result_array();
        }

        $this->db->select('order_id');
        $queryOrder = $this->db->get_where('ibhejo_order_details', array('id' => $id));
        $order_id = $queryOrder->row_array();

        //         $query = $this->db->get_where('ibhejo_order_product_details', array('order_id' => $order_id['order_id']));

        $this->db->select('*');
	    $this->db->from('ibhejo_order_product_details');
	    $this->db->where('order_id', $order_id['order_id']);
	    $query = $this->db->get();        
    	return $query->result_array();
    }

    function update_data($where=0, $data=0, $table_name='')
    {
        if($table_name == '')
        {
            echo "Table Name not found!";
            exit;
        }

        if($where != 0 && $data != 0)
        {
            $this->db->where($where);
            $this->db->update($table_name, $data);
            return 1;
        }
        else
        {
            echo "Error";
            exit;    
        } 
    }
}
