<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Orders_model extends CI_Model {

    function deleteProductByVendor($vendorName){

        $this->db->select('product_id')
             ->from('kp_product_details')
             ->where('vendor=', $vendorName);

        $query = $this->db->get();
        $productIds = $query->result_array();

        //$session = curl_init();
        $i=0;
        foreach ($productIds as $productId) {

            $productId = $productId['product_id'];

              // curl_setopt($session, CURLOPT_URL, "https://ec337c22123c8c7ba33be795e851137a:bf8822fc9fa0cbd128ca7ba731015a10@karmaplacecom.myshopify.com/admin/products/".$productId.".json");
              // curl_setopt($session, CURLOPT_CUSTOMREQUEST, "DELETE");
              // curl_setopt($session, CURLOPT_RETURNTRANSFER, TRUE);
              // curl_setopt($session, CURLOPT_TIMEOUT, 20);
              // curl_setopt($session, CURLOPT_CONNECTTIMEOUT, 20);
              // $res      = curl_exec($session);
              // $products = json_decode($res, true);

            $this->db->where('vendor', $vendorName);
            $this->db->delete('sku_price_details');

            $this->db-> where('product_id', $productId);
            $this->db-> delete('kp_variants_details');

            $this->db->where('product_id', $productId);
            $this->db->delete('kp_product_details');
        }

        echo $vendorName."'s total ".count($productIds)." products deleted sucessfully!!";

    }

    function insertPoInvoiceDetails($invoiceData){
        $this->db->insert('kp_invoice',$invoiceData);
    }

    function getOrderDetails(){
     
        $response = array();
     
        $this->db->from('kp_order_details');
        $this->db->order_by("id","desc");
        $response=$this->db->get();
        return $response->result_array();

    }

    function getPriceDetails(){

        $this->db->select('*')
                 ->from('sku_price_details');
            $query = $this->db->get();
            $qry = $query->row_array();
            return $qry;
    }

    function getProductImageDetails($id){

        $this->db->select('image')
             ->from('kp_product_details')
             ->where('product_id', $id);

        $query = $this->db->get();
        $qry = $query->row_array();
        return $qry;
    }

    function getProductTagDetails($id){

        $this->db->select('tags')
             ->from('kp_product_details')
             ->where('product_id', $id);

        $query = $this->db->get();
        $qry = $query->row_array();
        return $qry;
    }

    function hasEmailNotification($orderId){
         $this->db->select('email_notification')
             ->from('kp_order_details')
             ->where('order_id', $orderId);

        $query = $this->db->get();
        $qry = $query->row_array();
        return $qry;
    }

    function hasPoNotification($orderId){
         $this->db->select('po_notification')
             ->from('kp_order_product_details')
             ->where('order_id', $orderId);

        $query = $this->db->get();
        $qry = $query->row_array();
        return $qry;
    }

    function getPoVendorEmail($id){
        $this->db->select('vendor_email')
             ->from('kp_invoice')
             ->where('id', $id);

        $query = $this->db->get();
        $qry = $query->row_array();
        return $qry;
    }

    function getPoVendorDetails($id){
        $this->db->select('vendorDetails.*')
             ->from('kp_product_details')
             ->join('vendorDetails', 'kp_product_details.vendor = vendorDetails.vendorName', 'left')
             ->where('kp_product_details.product_id', $id);

        $query = $this->db->get();
        $qry = $query->row_array();
        return $qry;
    }

    function getInvoiceDetails($id){

        $this->db->select('*')
             ->from('kp_invoice')
             ->where('id', $id);

        $query = $this->db->get();
        $qry = $query->row_array();
        return $qry;
    }

    function updateInvoiceDetails($id){

        $data = [
            'mail' => 1,
        ];
        $this->db->where('id', $id);
        $this->db->update('kp_invoice', $data);

    }
	
	function approveOrderStatus($id){

        $data = [
            'order_status_admin' => "approved",
        ];
        $this->db->where('order_id', $id);
        $this->db->update('kp_order_details', $data);

    }

    // function updateInvoiceDetails($id, $data){
    //     $this->db->set('mail',1);
    //     $this->db->where('id', $id);
    //     $this->db->update('kp_invoice');
    // }

    function getPoSingleOrderDetails($id = 0) {
        if ($id === 0)
        {
            $query = $this->db->get('kp_order_details');
            return $query->result_array();
        }
 
        $query = $this->db->get_where('kp_order_details', array('order_id' => $id));

        // echo "<pre>";print_r($query->row_array());
        
        return $query->row_array();
    }

    function getPoBillingOrderDetails($id = 0) {
        if ($id === 0)
        {
            $query = $this->db->get('kp_billing_details');
            return $query->result_array();
        }
        $query = $this->db->get_where('kp_billing_details', array('order_id' => $id));
        return $query->row_array();
    }

    function getPoShippingOrderDetails($id = 0) {
        if ($id === 0)
        {
            $query = $this->db->get('kp_shipping_details');
            return $query->result_array();
        }

        $query = $this->db->get_where('kp_shipping_details', array('order_id' => $id));
        return $query->row_array();
    }

    function getPoOrderProductDetails($id = 0) {
        //todo: can revamp with join
        if ($id === 0)
        {
            $query = $this->db->get('kp_order_product_details');
            return $query->result_array();
        }

        $this->db->select('*');
        $this->db->from('kp_order_product_details');
        $this->db->where('order_id', $id);
        $query = $this->db->get();
        return $query->result_array();
    }


    function getSingleOrderDetails($id = 0) {
        if ($id === 0)
        {
            $query = $this->db->get('kp_order_details');
            return $query->result_array();
        }
 
        $query = $this->db->get_where('kp_order_details', array('id' => $id));

        // echo "<pre>";print_r($query->row_array());
        
        return $query->row_array();
    }

    function getBillingOrderDetails($id = 0) {
        if ($id === 0)
        {
            $query = $this->db->get('kp_billing_details');
            return $query->result_array();
        }

        $this->db->select('order_id');
        $queryOrder = $this->db->get_where('kp_order_details', array('id' => $id));
        $order_id = $queryOrder->row_array();

        $query = $this->db->get_where('kp_billing_details', array('order_id' => $order_id['order_id']));


        
        return $query->row_array();
    }

    function getShippingOrderDetails($id = 0) {
        if ($id === 0)
        {
            $query = $this->db->get('kp_shipping_details');
            return $query->result_array();
        }

        $this->db->select('order_id');
        $queryOrder = $this->db->get_where('kp_order_details', array('id' => $id));
        $order_id = $queryOrder->row_array();

        $query = $this->db->get_where('kp_shipping_details', array('order_id' => $order_id['order_id']) );
        
        return $query->row_array();
    }

    function getTrackingData($order_id = 0)
    {
        $this->db->select('*');
        $this->db->from('kp_order_product_custom_status');
        $this->db->where('order_id', $order_id);
        $this->db->where('status', 1);
        $this->db->order_by('product_sku'); 
        $query = $this->db->get();
        #echo $this->db->last_query();
        return $query->result_array();
    }

    function getOrderProductDetails($id = 0) {
        //todo: can revamp with join
		     $limit = 40;
			 $start = 0;

        if ($id === 0)
        {
            $query = $this->db->get('kp_order_product_details');
            return $query->result_array();
        }

        $this->db->select('order_id');
        $queryOrder = $this->db->get_where('kp_order_details', array('id' => $id));
        $order_id = $queryOrder->row_array();
		//echo "order_id/";
//print_r($order_id);exit;
        $this->db->select('*');
        $this->db->from('kp_order_product_details');
        $this->db->where('order_id', $order_id['order_id']);
		$this->db->limit($limit, $start);

        $query = $this->db->get();
        return $query->result_array();
    }

    function getOrderProducBySKU($id = 0, $product_sku = 0) {
        //todo: can revamp with join
        if ($id === 0 || $product_sku === 0)
        {
            echo 'order id require';exit;
        }

        $this->db->select('*');
        $this->db->from('kp_order_product_details');
        $this->db->where('order_id', $id);
        $this->db->where('product_sku', $product_sku);
        $query = $this->db->get();
        return $query->result_array();
    }


  function getiOrderDetails(){
 
    $response = array(); 
    $this->db->from('ibhejo_order_details');
    $this->db->order_by("id","desc");
    $response=$this->db->get();
    return $response->result_array();

  }

    function getiSingleOrderDetails($id = 0) {
        if ($id === 0)
        {
            $query = $this->db->get('ibhejo_order_details');
            return $query->result_array();
        }
 
        $query = $this->db->get_where('ibhejo_order_details', array('id' => $id));
        
        return $query->row_array();
    }

    function getiBillingOrderDetails($id = 0) {
        if ($id === 0)
        {
            $query = $this->db->get('ibhejo_billing_details');
            return $query->result_array();
        }

        $this->db->select('order_id');
        $queryOrder = $this->db->get_where('ibhejo_order_details', array('id' => $id));
        $order_id = $queryOrder->row_array();

        $query = $this->db->get_where('ibhejo_billing_details', array('order_id' => $order_id['order_id']));


        
        return $query->row_array();
    }

    function getiShippingOrderDetails($id = 0) {
        if ($id === 0)
        {
            $query = $this->db->get('ibhejo_shipping_details');
            return $query->result_array();
        }

        $this->db->select('order_id');
        $queryOrder = $this->db->get_where('ibhejo_order_details', array('id' => $id));
        $order_id = $queryOrder->row_array();

        $query = $this->db->get_where('ibhejo_shipping_details', array('order_id' => $order_id['order_id']));
        
        return $query->row_array();
    }

    function getiOrderProductDetails($id = 0) {
        if ($id === 0)
        {
            $query = $this->db->get('ibhejo_order_product_details');
            return $query->result_array();
        }

        $this->db->select('order_id');
        $queryOrder = $this->db->get_where('ibhejo_order_details', array('id' => $id));
        $order_id = $queryOrder->row_array();

        //         $query = $this->db->get_where('ibhejo_order_product_details', array('order_id' => $order_id['order_id']));

        $this->db->select('*');
        $this->db->from('ibhejo_order_product_details');
        $this->db->where('order_id', $order_id['order_id']);
        $query = $this->db->get();        
        return $query->result_array();
    }

    function update_data($where=0, $data=0, $table_name='')
    {
        if($table_name == '')
        {
            echo "Table Name not found!";
            exit;
        }

        if($where != 0 && $data != 0)
        {
            $this->db->where($where);
            $this->db->update($table_name, $data);
            return 1;
        }
        else
        {
            echo "Error";
            exit;    
        } 
    }

    // function update_data($where=0, $data=0, $table_name='')
    // {
    //     if($table_name == '')
    //     {
    //         echo "Table Name not found!";
    //         exit;
    //     }

    //     if($where != 0 && $data != 0)
    //     {
    //         $this->db->where($where);
    //         $this->db->update($table_name, $data);
    //         return 1;
    //     }
    //     else
    //     {
    //         echo "Error";
    //         exit;    
    //     } 
    // }

    function getOrderById($orderId,$table)
    {
        $this->db->where('order_id',$orderId);
        return $this->db->get($table);

    }

    function getImageByProductId($productId,$table)
    {
        $this->db->where('product_id',$productId);
        return $this->db->get($table);

    }


}
