<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Dashboard_model extends CI_Model {

    public function __construct()
    {
        parent::__construct();
    }


    public function get_count_record($table)
    {
        $query = $this->db->count_all($table);

        return $query;
    }


    public function disk_totalspace($dir = DIRECTORY_SEPARATOR)
    {
        return disk_total_space($dir);
    }


    public function disk_freespace($dir = DIRECTORY_SEPARATOR)
    {
        return disk_free_space($dir);
    }


    public function disk_usespace($dir = DIRECTORY_SEPARATOR)
    {
        return $this->disk_totalspace($dir) - $this->disk_freespace($dir);
    }


    public function disk_freepercent($dir = DIRECTORY_SEPARATOR, $display_unit = FALSE)
    {
        if ($display_unit === FALSE)
        {
            $unit = NULL;
        }
        else
        {
            $unit = ' %';
        }

        return round(($this->disk_freespace($dir) * 100) / $this->disk_totalspace($dir), 0).$unit;
    }


    public function disk_usepercent($dir = DIRECTORY_SEPARATOR, $display_unit = FALSE)
    {
        if ($display_unit === FALSE)
        {
            $unit = NULL;
        }
        else
        {
            $unit = ' %';
        }

        return round(($this->disk_usespace($dir) * 100) / $this->disk_totalspace($dir), 0).$unit;
    }


    public function memory_usage()
    {
        return memory_get_usage();
    }


    public function memory_peak_usage($real = TRUE)
    {
        if ($real)
        {
            return memory_get_peak_usage(TRUE);
        }
        else
        {
            return memory_get_peak_usage(FALSE);
        }
    }


    public function memory_usepercent($real = TRUE, $display_unit = FALSE)
    {
        if ($display_unit === FALSE)
        {
            $unit = NULL;
        }
        else
        {
            $unit = ' %';
        }

        return round(($this->memory_usage() * 100) / $this->memory_peak_usage($real), 0).$unit;
    }

    // KP orders count start 
    public function totalKpOrders ($table) {
      
        $query = $this->db->count_all($table);

        return $query;
  
    }
    
    public function totalKpPaidOrders ($table) {
		
		$this->db->from($table);
		$this->db->where('financial_status','paid');
        $query = $this->db->count_all_results();

        return $query;
  
    }
    
    public function totalKpPRefundedOrders ($table) {
		
		$this->db->from($table);
		$this->db->where('financial_status','partially_refun');
        $query = $this->db->count_all_results();

        return $query;
  
    }
    public function totalKpRefundedOrders ($table) {
		
		$this->db->from($table);
		$this->db->where('financial_status','refunded');
        $query = $this->db->count_all_results();

        return $query;
  
    }
    public function graphKPMonthlyOrders ($table) {		
		
		$this->db->select('COUNT(id) as totalOrder');
		$this->db->select('CONCAT((monthname(processed_at)),"-",(YEAR(processed_at))) as yearmonth');
		$this->db->select('YEAR(processed_at) as year');
		$this->db->from($table);
		$this->db->group_by('MONTH(processed_at)');
		$this->db->order_by('YEAR(processed_at) ASC, MONTH(processed_at) ASC');
		
        $query = $this->db->get();
        
        //~ print_r($query);
        if ($query->num_rows() > 0) {
			$result = $query->result_array();
		}
		
		//~ echo "<pre>"; print_r($result); echo "</pre>"; exit;
        return $result;
  
    }
    
    public function graphKPVendorOrders ($table) {		
		
		$this->db->select('COUNT(id) as totalOrder');
		$this->db->select('SUBSTRING(vendors, 1, 32) as vendors');
		$this->db->from($table);
		$this->db->group_by('vendors');
		$this->db->order_by('vendors ASC');
		
        $query = $this->db->get();
        
        //~ print_r($query);
        if ($query->num_rows() > 0) {
			$result = $query->result_array();
		}
		
		//~ echo "<pre>"; print_r($result); echo "</pre>"; exit;
        return $result;
  
    }
    
    // KP orders count end
    
    // IB orders count start 
    public function totalIBOrders ($table) {
      
        $query = $this->db->count_all($table);

        return $query;
  
    }
    
    public function totalIBPaidOrders ($table) {
		
		$this->db->from($table);
		$this->db->where('financial_status','paid');
        $query = $this->db->count_all_results();

        return $query;
  
    }
    
    public function totalIBPRefundedOrders ($table) {
		
		$this->db->from($table);
		$this->db->where('financial_status','pending');
        $query = $this->db->count_all_results();

        return $query;
  
    }
    public function totalIBRefundedOrders ($table) {
		
		$this->db->from($table);
		$this->db->where('financial_status','refunded');
        $query = $this->db->count_all_results();

        return $query;
  
    }
    
    public function graphIBMonthlyOrders ($table) {		
		
		$this->db->select('COUNT(id) as totalOrder');
		$this->db->select('CONCAT((monthname(processed_at)),"-",(YEAR(processed_at))) as yearmonth');
		$this->db->select('YEAR(processed_at) as year');
		$this->db->from($table);
		$this->db->group_by('MONTH(processed_at)');
		$this->db->order_by('YEAR(processed_at) ASC, MONTH(processed_at) ASC');
		
        $query = $this->db->get();
        
        //~ print_r($query);
        if ($query->num_rows() > 0) {
			$result = $query->result_array();
		}
		
		//~ echo "<pre>"; print_r($result); echo "</pre>"; exit;
        return $result;
  
    }
    
    // IB orders count end
    
}
