<?php
defined('BASEPATH') OR exit('No direct script access allowed');
include(APPPATH.'PHPExcel-1.8/Classes/PHPExcel/IOFactory.php');
error_reporting(0);

class Vendors extends Admin_Controller {

    public function __construct()
    {
        parent::__construct();

        // /* Load :: Common */
         $this->lang->load('admin/vendors');
         $this->load->model('Vendors_model');
         $this->load->model('admin/Vendororders_model');

        // /* Title Page :: Common */
        $this->page_title->push(lang('menu_vendors'));
         $this->data['pagetitle'] = $this->page_title->show();

        // /* Breadcrumbs :: Common */
         $this->breadcrumbs->unshift(1, lang('menu_vendors'), 'admin/vendors');
    }

    public function bulkupload()
    {
        $this->data['title'] = 'Bulk upload products';
        $this->template->admin_render('vendor/bulkupload', $this->data);
    }

	public function index()
	{
		//echo "raj";exit;
        if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
        // if ( ! $this->ion_auth->logged_in())
        {
            redirect('auth/login', 'refresh');
        }
        else
        {
            /* Breadcrumbs */
            $this->data['breadcrumb'] = $this->breadcrumbs->show();

            // /* Get all vendors */
             $this->data['vendors'] = $this->Vendors_model->getVendors();
            
             #echo $this->db->last_query();
            // foreach ($this->data['vendors'] as $k => $user)
            // {
            //     $this->data['vendors'][$k]->groups = $this->ion_auth->get_vendors_groups($user->id)->result();
            // }

            /* Load Template */
            $this->template->admin_render('admin/vendors/index', $this->data);
        }
	}

	public function vendorlog()
	{
        if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
        // if ( ! $this->ion_auth->logged_in())
        {
            redirect('auth/login', 'refresh');
        }
        else
        {
            /* Breadcrumbs */
            $this->data['breadcrumb'] = $this->breadcrumbs->show();

            // /* Get all vendors */
             $this->data['vendors'] = $this->Vendors_model->getVendorsLog();
            // foreach ($this->data['vendors'] as $k => $user)
            // {
            //     $this->data['vendors'][$k]->groups = $this->ion_auth->get_vendors_groups($user->id)->result();
            // }

            /* Load Template */
            $this->template->admin_render('admin/vendors/log', $this->data);
        }
	}



	public function create()
	{
        /* Breadcrumbs */
        $this->breadcrumbs->unshift(2, lang('menu_vendors_create'), 'admin/vendors/create');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();

		// print_r($_POST);exit;
        /* Variables */
		$tables = $this->config->item('tables', 'ion_auth');

		/* Validate form input */
		$this->form_validation->set_rules('name', 'lang:vendors_name', 'required,trim');
		// $this->form_validation->set_rules('email', 'lang:vendors_email', 'required');
		// $this->form_validation->set_rules('vendors_markup', 'lang:vendors_markup', 'required');
		// // $this->form_validation->set_rules('email', 'lang:vendors_email', 'required|valid_email|is_unique['.$tables['vendors'].'.email]');
		// // $this->form_validation->set_rules('phone', 'lang:vendors_phone', 'required');
		// // $this->form_validation->set_rules('type', 'lang:vendors_type', 'required');
		// $this->form_validation->set_rules('password', 'lang:vendors_password', 'required|min_length[' . $this->config->item('min_password_length', 'ion_auth') . ']|max_length[' . $this->config->item('max_password_length', 'ion_auth') . ']|matches[password_confirm]');
		// $this->form_validation->set_rules('password_confirm', 'lang:vendors_password_confirm', 'required');

		if ($this->form_validation->run() == TRUE)
		{
			$name = strtolower($this->input->post('name'));
			$email    = strtolower($this->input->post('email'));
			//$password = $this->input->post('password');

			$additional_data = array(
				'name' => $this->input->post('name'),
				'type'    => $this->input->post('type'),
				'phone'      => $this->input->post('phone'),
			);
		}

		if ($this->form_validation->run() == TRUE && $this->ion_auth->register($name, $password, $email, $additional_data))
		{
            $this->session->set_flashdata('message', $this->ion_auth->messages());
			redirect('admin/vendors', 'refresh');
		}else{
            $this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

			$this->data['name'] = array(
				'name'  => 'name',
				'id'    => 'name',
				'type'  => 'text',
                'class' => 'form-control',
				'value' => $this->form_validation->set_value('name'),
			);
			
			$this->data['email'] = array(
				'name'  => 'email',
				'id'    => 'email',
				'type'  => 'email',
                'class' => 'form-control',
				// 'value' => $this->form_validation->set_value('email'),
			);

			$this->data['vendors_weburl'] = array(
				'name'  => 'vendors_weburl',
				'id'    => 'vendors_weburl',
				'type'  => 'text',
                'class' => 'form-control',
				'value' => $this->form_validation->set_value('vendors_weburl'),
			);

			$this->data['vendors_address'] = array(
				'name'  => 'vendors_address',
				'id'    => 'vendors_address',
				'cols' => '2',
				'type'  => 'textarea',
                'class' => 'form-control',
				'value' => $this->form_validation->set_value('vendors_address'),
			);

			$this->data['vendors_markup'] = array(
				'name'  => 'vendors_markup',
				'id'    => 'vendors_markup',
				'type'  => 'text',
                'class' => 'form-control',
				'value' => $this->form_validation->set_value('vendors_markup'),
			);

			$this->data['vendors_cpname'] = array(
				'name'  => 'vendors_cpname',
				'id'    => 'vendors_cpname',
				'type'  => 'text',
                'class' => 'form-control',
				'value' => $this->form_validation->set_value('vendors_cpname'),
			);

			$this->data['vendors_cpphone'] = array(
				'name'  => 'vendors_cpphone',
				'id'    => 'vendors_cpphone',
				'type'  => 'text',
                'class' => 'form-control',
				'value' => $this->form_validation->set_value('vendors_cpphone'),
			);

			$this->data['vendors_cpemail'] = array(
				'name'  => 'vendors_cpemail',
				'id'    => 'vendors_cpemail',
				'type'  => 'text',
                'class' => 'form-control',
				'value' => $this->form_validation->set_value('vendors_cpemail'),
			);

			$this->data['vendors_status'] = array(
				'name'  => 'vendors_status',
				'id'    => 'vendors_status',
				'type'  => 'text',
                'class' => 'form-control',
				'value' => $this->form_validation->set_value('vendors_status'),
			);

			$this->data['type'] = array(
				'name'  => 'type',
				'id'    => 'type',
				'type'  => 'text',
                'class' => 'form-control',
				'value' => $this->form_validation->set_value('type'),
			);

			$this->data['phone'] = array(
				'name'  => 'phone',
				'id'    => 'phone',
				'type'  => 'tel',
                'pattern' => '^((\+\d{1,3}(-| )?\(?\d\)?(-| )?\d{1,5})|(\(?\d{2,6}\)?))(-| )?(\d{3,4})(-| )?(\d{4})(( x| ext)\d{1,5}){0,1}$',
                'class' => 'form-control',
				'value' => $this->form_validation->set_value('phone'),
			);

			// $this->data['password'] = array(
			// 	'name'  => 'password',
			// 	'id'    => 'password',
			// 	'type'  => 'password',
	   //              'class' => 'form-control',
				// 	'value' => $password,//$this->form_validation->set_value('password'),
				// );

				// $this->data['password_confirm'] = array(
				// 	'name'  => 'password_confirm',
				// 	'id'    => 'password_confirm',
				// 	'type'  => 'password',
	   //              'class' => 'form-control',
			// 	'value' => $password,//$this->form_validation->set_value('password_confirm'),
			// );

			// $this->data['vendors'] = $this->Vendors_model->createVendors();
			 // print_r($_POST);exit;

			if($this->input->post('name')){	
				
				// if($this->Vendors_model->checkVendors($email) == TRUE){
				// 	//redirect('admin/vendors', 'refresh');
				// 	$this->template->admin_render('admin/vendors/create', 'Error');
				// }
				$this->data['message'] = 'Vendor added successfully!';
				$this->Vendors_model->createVendors();
			}

            /* Load Template */
		//echo "<pre>"; print_r($this->data); exit;
            $this->template->admin_render('admin/vendors/create', $this->data);
        }
	}


	public function vendorupload()
	{
		$this->data['breadcrumb'] = $this->breadcrumbs->show();

		/* Load Template */
        $this->template->admin_render('admin/vendors/vendorupload', $this->data);
	}

	public function vendorexport()
	{
		$this->data['breadcrumb'] = $this->breadcrumbs->show();

		$this->db->select('*');
	    $q = $this->db->get('vendorDetails');
	    $result = $q->result_array();

	 	//    echo "<pre>";print_r($response);

		// $result = mysql_query('SELECT * FROM `employee_data`');

		if (!$result) die('Couldn\'t fetch records');

		//$num_fields = mysql_num_fields($result);
		//$headers = array();
		// for ($i = 0; $i < $num_fields; $i++) {
		//     $headers[] = mysql_field_name($result , $i);
		// }

		$fp = fopen('php://output', 'w');
		if ($fp && $result) {
		    header('Content-Type: text/csv');
		    header('Content-Disposition: attachment; filename="export.csv"');
		    header('Pragma: no-cache');
		    header('Expires: 0');
		    
		    $columns_title =  array('id','vendorName','vendorEmail','vendorMarkup','vendorAcStatus','vendorPwd');
        	fputcsv($fp, $columns_title);

        	$items_csv = array();
	        $i =0;
	        foreach ($result as $val)
	        {
	            #print_r($val);

	            if($val['vendorAcStatus'] == 1){
	            	$status = 'Active';
	            }else{
	            	$status = 'Inactive';
	            }

	            $items_csv[$i]['id']    	     = $val['id'];
	            $items_csv[$i]['vendorName']     = $val['vendorName'];
				$items_csv[$i]['vendorEmail']    = $val['vendorEmail'];
	            $items_csv[$i]['vendorMarkup']   = $val['vendorMarkup'];
				$items_csv[$i]['vendorAcStatus'] = $status;
	            $items_csv[$i]['vendorPwd']      = $val['vendorPwd'];

	            fputcsv($fp,$items_csv[$i]);
	            $i++;
	        }


		    die;
		}

		/* Load Template */
        $this->template->admin_render('admin/vendors', $this->data);
	}

	public function checkVendorEmail()
	{


		$email =$this->input->post('email');           
		$this->Vendors_model->checkVendors($email);        
		/* Load Template */
		// redirect('admin/vendors', 'refresh');
	}


	public function delete()
	{
		$id =$this->uri->segment(4);           
		$this->Vendors_model->deleteVendor($id);
        /* Load Template */
		redirect('admin/vendors', 'refresh');
	}

	public function logview() {

		$this->breadcrumbs->unshift(2, lang('menu_vendors_edit'), 'admin/vendors/edit');
	    $this->data['breadcrumb'] = $this->breadcrumbs->show();
	    $id = $this->input->post('id');

		$userId = $this->uri->segment(4);
		
		$this->data['vendorDetails'] = $this->Vendors_model->getVendorsLogById($userId);
		
		// echo "<pre>"; print_r($this->data['vendorDetails']); exit;
		
		$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));


			$this->data['name'] = array(
				'name'  => 'name',
				'id'    => 'name',
				'type'  => 'text',
                'class' => 'form-control',
				'value' => $this->data['vendorDetails']['vendorName'],
			);
			
			$this->data['email'] = array(
				'name'  => 'email',
				'id'    => 'email',
				'type'  => 'email',
                'class' => 'form-control',
				'value' => $this->data['vendorDetails']['vendorEmail'],
			);

			$this->data['vendors_weburl'] = array(
				'name'  => 'vendors_weburl',
				'id'    => 'vendors_weburl',
				'type'  => 'text',
                'class' => 'form-control',
				'value' => $this->data['vendorDetails']['vendorWebURL'],

			);

			$this->data['vendors_address'] = array(
				'name'  => 'vendors_address',
				'id'    => 'vendors_address',
				'cols' => '2',
				'type'  => 'textarea',
                'class' => 'form-control',
				'value' => $this->data['vendorDetails']['vendorAddress'],
			);

			$this->data['vendors_markup'] = array(
				'name'  => 'vendors_markup',
				'id'    => 'vendors_markup',
				'type'  => 'text',
                'class' => 'form-control',
				'value' => $this->data['vendorDetails']['vendorMarkup'],
			);

			$this->data['vendors_cpname'] = array(
				'name'  => 'vendors_cpname',
				'id'    => 'vendors_cpname',
				'type'  => 'text',
                'class' => 'form-control',
				'value' => $this->data['vendorDetails']['vendorCPName'],
			);

			$this->data['vendors_cpphone'] = array(
				'name'  => 'vendors_cpphone',
				'id'    => 'vendors_cpphone',
				'type'  => 'text',
                'class' => 'form-control',
                'pattern' => '^((\+\d{1,3}(-| )?\(?\d\)?(-| )?\d{1,5})|(\(?\d{2,6}\)?))(-| )?(\d{3,4})(-| )?(\d{4})(( x| ext)\d{1,5}){0,1}$',
				'value' => $this->data['vendorDetails']['vendorCPPhone'],
			);

			$this->data['vendors_cpemail'] = array(
				'name'  => 'vendors_cpemail',
				'id'    => 'vendors_cpemail',
				'type'  => 'text',
                'class' => 'form-control',
				'value' => $this->data['vendorDetails']['vendorCPEmail'],
			);

			$this->data['vendors_status'] = array(
				'name'  => 'vendors_status',
				'id'    => 'vendors_status',
				'type'  => 'text',
                'class' => 'form-control',
				'value' => $this->data['vendorDetails']['vendorAcStatus'],
			);

			$this->data['type'] = array(
				'name'  => 'type',
				'id'    => 'type',
				'type'  => 'text',
                'class' => 'form-control',
				'value' => $this->data['vendorDetails']['vendorType'],
			);
			$this->data['password'] = array(
				'name'  => 'password',
				'id'    => 'password',
				'type'  => 'password',
                'class' => 'form-control',
				'value' => $this->data['vendorDetails']['vendorPwd'],
			);
			$this->data['password_confirm'] = array(
				'name'  => 'password_confirm',
				'id'    => 'password_confirm',
				'type'  => 'password',
                'class' => 'form-control',
				'value' => $this->data['vendorDetails']['vendorPwd'],
			);

		$this->template->admin_render('admin/vendors/logview', $this->data);
		// if($this->input->post('name')){	
		// 	$this->Vendors_model->editVendors($id);
		// 	 redirect('admin/vendors', 'refresh');
		// }
		// $this->template->admin_render('admin/vendors/edit', $this->data);

	}

	public function edit() {

		$this->breadcrumbs->unshift(2, lang('menu_vendors_edit'), 'admin/vendors/edit');
	    $this->data['breadcrumb'] = $this->breadcrumbs->show();
	    $id = $this->input->post('id');

		$userId = $this->uri->segment(4);
		
		$this->data['vendorDetails'] = $this->Vendors_model->getVendorsById($userId);
		
		// echo "<pre>"; print_r($this->data['vendorDetails']); exit;
		
		$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));


			$this->data['name'] = array(
				'name'  => 'name',
				'id'    => 'name',
				'type'  => 'text',
                'class' => 'form-control',
				'value' => $this->data['vendorDetails']['vendorName'],
			);
			
			$this->data['email'] = array(
				'name'  => 'email',
				'id'    => 'email',
				'type'  => 'email',
                'class' => 'form-control',
				'value' => $this->data['vendorDetails']['vendorEmail'],
			);

			$this->data['vendors_weburl'] = array(
				'name'  => 'vendors_weburl',
				'id'    => 'vendors_weburl',
				'type'  => 'text',
                'class' => 'form-control',
				'value' => $this->data['vendorDetails']['vendorWebURL'],

			);

			$this->data['vendors_address'] = array(
				'name'  => 'vendors_address',
				'id'    => 'vendors_address',
				'cols' => '2',
				'type'  => 'textarea',
                'class' => 'form-control',
				'value' => $this->data['vendorDetails']['vendorAddress'],
			);

			$this->data['vendors_markup'] = array(
				'name'  => 'vendors_markup',
				'id'    => 'vendors_markup',
				'type'  => 'text',
                'class' => 'form-control',
				'value' => $this->data['vendorDetails']['vendorMarkup'],
			);

			$this->data['vendors_cpname'] = array(
				'name'  => 'vendors_cpname',
				'id'    => 'vendors_cpname',
				'type'  => 'text',
                'class' => 'form-control',
				'value' => $this->data['vendorDetails']['vendorCPName'],
			);

			$this->data['vendors_cpphone'] = array(
				'name'  => 'vendors_cpphone',
				'id'    => 'vendors_cpphone',
				'type'  => 'text',
                'class' => 'form-control',
                'pattern' => '^((\+\d{1,3}(-| )?\(?\d\)?(-| )?\d{1,5})|(\(?\d{2,6}\)?))(-| )?(\d{3,4})(-| )?(\d{4})(( x| ext)\d{1,5}){0,1}$',
				'value' => $this->data['vendorDetails']['vendorCPPhone'],
			);

			$this->data['vendors_cpemail'] = array(
				'name'  => 'vendors_cpemail',
				'id'    => 'vendors_cpemail',
				'type'  => 'text',
                'class' => 'form-control',
				'value' => $this->data['vendorDetails']['vendorCPEmail'],
			);

			$this->data['vendors_status'] = array(
				'name'  => 'vendors_status',
				'id'    => 'vendors_status',
				'type'  => 'text',
                'class' => 'form-control',
				'value' => $this->data['vendorDetails']['vendorAcStatus'],
			);

			$this->data['type'] = array(
				'name'  => 'type',
				'id'    => 'type',
				'type'  => 'text',
                'class' => 'form-control',
				'value' => $this->data['vendorDetails']['vendorType'],
			);
			$this->data['password'] = array(
				'name'  => 'password',
				'id'    => 'password',
				'type'  => 'password',
                'class' => 'form-control',
				'value' => $this->data['vendorDetails']['vendorPwd'],
			);
			$this->data['password_confirm'] = array(
				'name'  => 'password_confirm',
				'id'    => 'password_confirm',
				'type'  => 'password',
                'class' => 'form-control',
				'value' => $this->data['vendorDetails']['vendorPwd'],
			);

		$this->template->admin_render('admin/vendors/edit', $this->data);
		if($this->input->post('name')){	
			$this->Vendors_model->editVendors($id);
		     $this->data['message'] = 'Vendor edited successfully!';
			 redirect('admin/vendors', 'refresh');
		}
		// $this->template->admin_render('admin/vendors/edit', $this->data);

	}

	/*
	public function edit($id)
	{
        $id = (int) $id;

		if ( ! $this->ion_auth->logged_in() OR ( ! $this->ion_auth->is_admin() && ! ($this->ion_auth->user()->row()->id == $id)))
		{
			redirect('auth', 'refresh');
		}

        // Breadcrumbs 
        $this->breadcrumbs->unshift(2, lang('menu_vendors_edit'), 'admin/vendors/edit');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();

        // Data 
		$user          = $this->ion_auth->user($id)->row();
		$groups        = $this->ion_auth->groups()->result_array();
		$currentGroups = $this->ion_auth->get_vendors_groups($id)->result();

		 //Validate form input 
		$this->form_validation->set_rules('first_name', 'lang:edit_user_validation_fname_label', 'required');
		$this->form_validation->set_rules('last_name', 'lang:edit_user_validation_lname_label', 'required');
		$this->form_validation->set_rules('phone', 'lang:edit_user_validation_phone_label', 'required');
		$this->form_validation->set_rules('company', 'lang:edit_user_validation_company_label', 'required');

		if (isset($_POST) && ! empty($_POST))
		{
            if ($this->_valid_csrf_nonce() === FALSE OR $id != $this->input->post('id'))
			{
				show_error($this->lang->line('error_csrf'));
			}

            if ($this->input->post('password'))
			{
				$this->form_validation->set_rules('password', $this->lang->line('edit_user_validation_password_label'), 'required|min_length[' . $this->config->item('min_password_length', 'ion_auth') . ']|max_length[' . $this->config->item('max_password_length', 'ion_auth') . ']|matches[password_confirm]');
				$this->form_validation->set_rules('password_confirm', $this->lang->line('edit_user_validation_password_confirm_label'), 'required');
			}

			if ($this->form_validation->run() == TRUE)
			{
				$data = array(
					'first_name' => $this->input->post('first_name'),
					'last_name'  => $this->input->post('last_name'),
					'company'    => $this->input->post('company'),
					'phone'      => $this->input->post('phone')
				);

                if ($this->input->post('password'))
				{
					$data['password'] = $this->input->post('password');
				}

                if ($this->ion_auth->is_admin())
				{
                    $groupData = $this->input->post('groups');

					if (isset($groupData) && !empty($groupData))
                    {
						$this->ion_auth->remove_from_group('', $id);

						foreach ($groupData as $grp)
                        {
							$this->ion_auth->add_to_group($grp, $id);
						}
					}
				}

                if($this->ion_auth->update($user->id, $data))
			    {
                    $this->session->set_flashdata('message', $this->ion_auth->messages());

				    if ($this->ion_auth->is_admin())
					{
						redirect('admin/vendors', 'refresh');
					}
					else
					{
						redirect('admin', 'refresh');
					}
			    }
			    else
			    {
                    $this->session->set_flashdata('message', $this->ion_auth->errors());

				    if ($this->ion_auth->is_admin())
					{
						redirect('auth', 'refresh');
					}
					else
					{
						redirect('/', 'refresh');
					}
			    }
			}
		}

		// display the edit user form
		$this->data['csrf'] = $this->_get_csrf_nonce();

		// set the flash data error message if there is one
		$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

		// pass the user to the view
		$this->data['user']          = $user;
		$this->data['groups']        = $groups;
		$this->data['currentGroups'] = $currentGroups;

		$this->data['first_name'] = array(
			'name'  => 'first_name',
			'id'    => 'first_name',
			'type'  => 'text',
            'class' => 'form-control',
			'value' => $this->form_validation->set_value('first_name', $user->first_name)
		);
		$this->data['last_name'] = array(
			'name'  => 'last_name',
			'id'    => 'last_name',
			'type'  => 'text',
            'class' => 'form-control',
			'value' => $this->form_validation->set_value('last_name', $user->last_name)
		);
		$this->data['company'] = array(
			'name'  => 'company',
			'id'    => 'company',
			'type'  => 'text',
            'class' => 'form-control',
			'value' => $this->form_validation->set_value('company', $user->company)
		);
		$this->data['phone'] = array(
			'name'  => 'phone',
			'id'    => 'phone',
            'type'  => 'tel',
            'pattern' => '^((\+\d{1,3}(-| )?\(?\d\)?(-| )?\d{1,5})|(\(?\d{2,6}\)?))(-| )?(\d{3,4})(-| )?(\d{4})(( x| ext)\d{1,5}){0,1}$',
            'class' => 'form-control',
			'value' => $this->form_validation->set_value('phone', $user->phone)
		);
		$this->data['password'] = array(
			'name' => 'password',
			'id'   => 'password',
            'class' => 'form-control',
			'type' => 'password'
		);
		$this->data['password_confirm'] = array(
			'name' => 'password_confirm',
			'id'   => 'password_confirm',
            'class' => 'form-control',
			'type' => 'password'
		);


         //Load Template 
		$this->template->admin_render('admin/vendors/edit', $this->data);
	}*/


	function activate($id, $code = FALSE)
	{
        $id = (int) $id;

		if ($code !== FALSE)
		{
            $activation = $this->ion_auth->activate($id, $code);
		}
		else if ($this->ion_auth->is_admin())
		{
			$activation = $this->ion_auth->activate($id);
		}

		if ($activation)
		{
            $this->session->set_flashdata('message', $this->ion_auth->messages());
			redirect('admin/vendors', 'refresh');
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
			redirect('auth/forgot_password', 'refresh');
		}
	}


	public function deactivate($id = NULL)
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
            return show_error('You must be an administrator to view this page.');
		}

        /* Breadcrumbs */
        $this->breadcrumbs->unshift(2, lang('menu_vendors_deactivate'), 'admin/vendors/deactivate');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();

		/* Validate form input */
		$this->form_validation->set_rules('confirm', 'lang:deactivate_validation_confirm_label', 'required');
		$this->form_validation->set_rules('id', 'lang:deactivate_validation_user_id_label', 'required|alpha_numeric');

		$id = (int) $id;

		if ($this->form_validation->run() === FALSE)
		{
			$user = $this->ion_auth->user($id)->row();

            $this->data['csrf']       = $this->_get_csrf_nonce();
            $this->data['id']         = (int) $user->id;
            $this->data['firstname']  = ! empty($user->first_name) ? htmlspecialchars($user->first_name, ENT_QUOTES, 'UTF-8') : NULL;
            $this->data['lastname']   = ! empty($user->last_name) ? ' '.htmlspecialchars($user->last_name, ENT_QUOTES, 'UTF-8') : NULL;

            /* Load Template */
            $this->template->admin_render('admin/vendors/deactivate', $this->data);
		}
		else
		{
            if ($this->input->post('confirm') == 'yes')
			{
                if ($this->_valid_csrf_nonce() === FALSE OR $id != $this->input->post('id'))
				{
                    show_error($this->lang->line('error_csrf'));
				}

                if ($this->ion_auth->logged_in() && $this->ion_auth->is_admin())
				{
					$this->ion_auth->deactivate($id);
				}
			}

			redirect('admin/vendors', 'refresh');
		}
	}


	// public function profile($id)
	// {
 //        /* Breadcrumbs */
 //        $this->breadcrumbs->unshift(2, lang('menu_vendors_profile'), 'admin/groups/profile');
 //        $this->data['breadcrumb'] = $this->breadcrumbs->show();

 //        /* Data */
 //        $id = (int) $id;

 //        $this->data['user_info'] = $this->ion_auth->user($id)->result();
 //        foreach ($this->data['user_info'] as $k => $user)
 //        {
 //            $this->data['user_info'][$k]->groups = $this->ion_auth->get_vendors_groups($user->id)->result();
 //        }

 //        /* Load Template */
	// 	$this->template->admin_render('admin/vendors/profile', $this->data);
	// }


	public function _get_csrf_nonce()
	{
		$this->load->helper('string');
		$key   = random_string('alnum', 8);
		$value = random_string('alnum', 20);
		$this->session->set_flashdata('csrfkey', $key);
		$this->session->set_flashdata('csrfvalue', $value);

		return array($key => $value);
	}


	public function _valid_csrf_nonce()
	{
		if ($this->input->post($this->session->flashdata('csrfkey')) !== FALSE && $this->input->post($this->session->flashdata('csrfkey')) == $this->session->flashdata('csrfvalue'))
		{
			return TRUE;
		}
		else
		{
			return FALSE;
		}
	}

	  function vendordocumentsById($id)
    {
    	$this->load->helper('url');

     // Load zip library
     $this->load->library('zip');

    	if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
            return show_error('You must be an administrator to view this page.');
		}

       if($_POST['id']){
       	$listdoc="";
       	$id = $_POST['id'];
       		 $response = $this->Vendororders_model->getvendoedocgstpaneagree($id);
       		 foreach ($response as $vndr => $vndrVal) {
       		 	$filepath = $vndrVal['filepath'];
       		 	$filepath = base_url().str_replace('/var/www/html/kptracking/pricecalc/','',$filepath);
       		 	$fileof =$vndrVal['filetypes'];
       		 	$this->zip->read_file($filepath);
       		 	$listdoc .= "<a href='".$filepath."' download class='edocelmt ".$fileof."' target='_blank'>".$fileof."</a>";
       		 }

       		 //  $filename = "vendot_document_".$id.".zip";
       		 //  $filezipath - '/var/www/html/kptracking/pricecalc/pdfs-EAgreement/vendordoczip/'.$filename;
      		  // //$this->zip->download($filename);
      		  // $this->zip->archive($filezipath);
      		  // if ( $this->zip->archive($filezipath)) {
      		  //  echo "File Downloaded";
      		  // } else {
      		  // 	 echo "File Not Downloaded";
      		  // }
       		 echo  $listdoc;

 				
       }
    }
    
}
