<?php
defined('BASEPATH') OR exit('No direct script access allowed');
error_reporting(0);

class Update extends Admin_Controller
{
    public function __construct()
    {
        parent::__construct();
        #error_reporting(E_ALL & ~E_NOTICE);

        // /* Load :: Common */
        $this->lang->load('admin/vendors');
        $this->load->model('admin/Orders_model');
        $this->load->model('admin/Vendororders_model');
        // $this->load->model('admin/Orders_model');


        // /* Title Page :: Common */
        $this->page_title->push(lang('menu_vendors'));
        $this->data['pagetitle'] = $this->page_title->show();

        // /* Breadcrumbs :: Common */
        $this->breadcrumbs->unshift(1, lang('menu_vendors'), 'admin/vendors');
        error_reporting(0);
        ini_set('DISPLAY_ERRORS', 0);
        #error_reporting(E_ALL); ini_set('DISPLAY_ERRORS', 1);
    }


    public function index()
    {
        if (!$this->ion_auth->logged_in() OR !$this->ion_auth->is_admin()) // if ( ! $this->ion_auth->logged_in())
        {
            redirect('auth/login', 'refresh');
        } else {
            /* Breadcrumbs */
            $this->data['orders'] = $this->Orders_model->getOrderDetails();
            /* Load Template */
            $this->template->admin_render('admin/orders/index', $this->data);
        }
    }

    public function productupdate()
    {

        $api_key = '6817756f7b312d21867786e3ab92d8b4';
        $api_pass = '384d011b0e4e488e6e79a241821ed98b';

        $email = $this->session->userdata['email'];
        $vendorUserId = $this->session->userdata['vendor_user_id'];
        $vendorName = $this->session->userdata['vendor_name'];
        $image = $this->input->post('image');
        $productId = $this->input->post('product_id');
        $variantId = $this->input->post('variant_id');
        $grams = $this->input->post('grams');
        $priceOld = $this->input->post('price_old');
        $quantityOld = $this->input->post('inventory_quantity');
        $priceNew = $this->input->post('price');
        $quantityNew = $this->input->post('qty');
        $created_at = date("F j, Y, g:i a");

        $this->db->select('vendorMarkup');
        $this->db->where('id', $vendorUserId);
        $q = $this->db->get('vendorDetails');
        $responseMarkup = $q->result_array();

        $this->db->select('conversionRate');
        $q = $this->db->get('globalMarkupDetails');
        $responseRate = $q->result_array();

        $priceInDollar = $priceNew / $responseRate[0]['conversionRate'];
        $markupPrice = $priceInDollar * $responseMarkup[0]['vendorMarkup'];
        $shippingRate = (ceil(($grams / 500)) * 4);
        $priceInDollarFinal = round($priceInDollar + $markupPrice + $shippingRate);
        // $priceInInrRound = round($priceInInr);
        $dataApi = array(
            'product' => array(
                'id' => $productId,
                'variant' => array(
                    'id' => $variantId,
                    'price' => $priceInDollarFinal,
                    'inventory_quantity' => $quantityNew,
                    'old_inventory_quantity' => $quantityOld
                )
            )
        );
        // echo "<pre>";print_r($dataApi);echo "</pre>";
        $dataInsert = array(
            'email' => $email,
            'vendor_user_id' => $vendorUserId,
            'vendor_name' => $vendorName,
            'image' => $image,
            'product_id' => $productId,
            'variant_id' => $variantId,
            'price_old' => $this->input->post('price_old_inr'),
            'qty_old' => $quantityOld,
            'price_new' => $this->input->post('price'),
            'qty_new' => $quantityNew,
            'created_at' => $created_at
        );

        $dataUpdate = array(
            'email' => $email,
            'vendor_user_id' => $vendorUserId,
            'vendor_name' => $vendorName,
            'image' => $image,
            'product_id' => $productId,
            'variant_id' => $variantId,
            'price_old' => $priceOld,
            'qty_old' => $quantityOld,
            'price_new' => $priceInDollarFinal,
            'qty_new' => $quantityNew,
            'created_at' => $created_at
        );

        $this->Vendororders_model->insertProductDetails($dataInsert);
        $this->Vendororders_model->updateProductDetails($dataUpdate);

        $url = "https://$api_key:$api_pass@karmaplacecom.myshopify.com/admin/products/$productId.json";
        $curl = curl_init($url);
        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "PUT");
        curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($dataApi));
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        $result = curl_exec($curl);
        curl_close($curl);

        $result = json_decode($result);
        #echo "<pre>";print_r($result);echo "</pre>";exit;
        $this->session->set_flashdata('msg', 'Product updated successfully!');
        // $productId = $this->uri->segment('4');
        $this->data['product'] = $this->Vendororders_model->getVendorSingleProduct($productId);
        // $this->template->admin_render('vendor/products', $this->data);
        redirect("admin/orders/productedit/" . $productId, $this->data);

    }

    public function checkTags($tag, $price)
    {

        $tagsAboveBelow = array(

            "kurtas-suits",
            "kurtis-tunics",
            "pendants",
            "bohemian-casual-necklaces",
            "necklace-earring-sets",
            "chains",
            "bead-necklaces",
            "ethnic-wedding-necklaces",
            "mangalsutra-sets",
            "anklets",
            "body-chains",
            "head-gear",
            "nose-rings",
            "arm-bands",
            "toe-rings",
            "brooches-pins-clips",
            "ghungroo",
            "bangles",
            "diamond",
            "multistone",
            "beads-pearls",
            "kada-bangles",
            "glass-bangles",
            "silk-bangles",
            "womens-bracelets",
            "plain-bracelets",
            "charm-bracelets",
            "womens-bracelets",
            "cuffs",
            "openable-bangles",
            "jhumka-dangling",
            "large-dangle-earrings",
            "chandelier-earrings",
            "hoop-earrings",
            "drop-earrings",
            "studs-non-dangling-earrings",
            "pearl-stud-earrings",
            "feather-earrings",
            "ear-cuffs",
            "mens-rings",
            "mens-bracelets",
            "cufflinks",
            "solitaire-engagement-rings",
            "statement-rings",
            "multistone-rings",
            "adjustable-size-rings"
        );


        if (in_array(strtolower($tag), $tagsAboveBelow)) {
            if ($price > 500) {
                $markup = 50;
            } else {
                $markup = 65;
            }

        } else {
            $markup = 50;
        }

        if ($tag == 'myntracrawl-karmaplace') {
            $markup = 95;
        } elseif ($tag == 'mandirs') {
            $markup = 80;
        } elseif ($tag == 'Rakhi') {
            $markup = 65;
        }


        return $markup;

    }

    public function updateVariant()
    {
        $user_type = $this->input->post('user_type');
		
		//Admin User
		if($user_type == 1) {
			#error_reporting(0); ini_set('DISPLAY_ERROS', 0);
			$in_search_tag = array("silk-saree", "cotton-silk-saree", "cotton-saree", "georgette-saree", "chiffon-saree", "jacquard-saree", "net-saree", "satin-saree", "embroidered-saree", "handloom-saree", "traditional-bandhani-paithani", "designer-saree");
			$in_lehengas_earch_tag = array('lehengas');
			$inventory_quantity = $this->input->post('inventory_quantity');
			$priceNew = $this->input->post('variant_price');
			$compare_at_price_inr = !empty($this->input->post('compare_at_price_inr')) ? $this->input->post('compare_at_price_inr') : 0;
			$variant_id = $this->input->post('variant_id');
			$old_variant_price = $this->input->post('old_variant_price');
			$old_inventory_quantity = $this->input->post('old_inventory_quantity');
			$product_id = $this->input->post('product_id');
			$variant_position = $this->input->post('variant_position');
			$image = $this->input->post('variant_image');
			$grams = $this->input->post('grams');

			$email = $this->session->userdata['email'];
			$vendorUserId = $this->session->userdata['vendor_user_id'];
			$vendorName = $this->session->userdata['vendor_name'];

			$sqlTags = 'SELECT `tags` from `kp_product_details` WHERE `product_id` =' . $product_id . ' LIMIT 1';
			$sqlTagsResult = $this->db->query($sqlTags);
			foreach ($sqlTagsResult->result() as $row) {
				$productTags = str_replace(" ", "", strtolower($row->tags));
			}
			$productTagsArray = explode(',', $productTags);
			foreach ($productTagsArray as $productTags) {
				$markUps[] = $this->checkTags(trim($productTags), $priceNew);
				if (trim($productTags) == 'mandirs') {
					$shippingMandirTrue = 'true';
				}
				if (trim($productTags) == 'food') {
					$shippingFoodTrue = 'true';
				}
			}

			$markUp = max($markUps);

			$hasSarreTag = array_intersect($in_search_tag, $productTagsArray);
			$hasLehengasTag = array_intersect($in_lehengas_earch_tag, $productTagsArray);
			$extra_parameter_saree = 0;
			$extra_parameter_lehengas = 0;
			if (count($hasSarreTag) > 0) {
				$extra_parameter_saree = 6;

			}
			if (count($hasLehengasTag) > 0) {
				$extra_parameter_lehengas = 15;

			}
			if (empty($vendorUserId)) {
				#echo 'in vendor id empty';
				$sqlVendor = 'SELECT  `vendor`.`id` 
					FROM  `kp_product_details` AS  `prods` 
					INNER JOIN  `vendorDetails` AS  `vendor` ON (  `prods`.`vendor` =  `vendor`.`vendorName` ) 
					WHERE  `prods`.`product_id` =' . $product_id;
				$sqlVendorResult = $this->db->query($sqlVendor);

				foreach ($sqlVendorResult->result() as $row) {
					$vendorUserId = $row->id;
				}
				#echo 'vendorUserId '.$vendorUserId;exit;
			}
			$created_at = date("F j, Y, g:i a");
			$api_key = '6817756f7b312d21867786e3ab92d8b4';
			$api_pass = '384d011b0e4e488e6e79a241821ed98b';

			$this->db->select('vendorMarkup');
			$this->db->where('id', $vendorUserId);
			$q = $this->db->get('vendorDetails');
			$responseMarkup = $q->result_array();

			$this->db->select('conversionRate');
			$q = $this->db->get('globalMarkupDetails');
			$responseRate = $q->result_array();
			$priceInDollar = $priceNew / $responseRate[0]['conversionRate'];
			$vendormarkup = $markUp; //$responseMarkup[0]['vendorMarkup'];
			$markupPrice = $priceInDollar * ($vendormarkup / 100);
			$cntWeightParts = ceil($grams / 500);
			$shippingRate = 5 + ($cntWeightParts - 1) * 5;
			if ($shippingMandirTrue == 'true') {
				$shippingRate = $cntWeightParts * 8;
			}
			if ($shippingFoodTrue == 'true') {
				$shippingRate = 2 + ($cntWeightParts - 1) * 2;
			}

			#$shippingRate = (ceil(($grams/500))*4);
			$priceInDollarFinal = ceil($priceInDollar + $markupPrice + $shippingRate + $extra_parameter_saree + $extra_parameter_lehengas);

			$log = array('shipping rates' => $shippingRate, 'dollar' => $priceInDollar, 'vendormarkup according tag' => $vendormarkup, 'markupPrice' => $markupPrice, 'priceInDollarFinal' => $priceInDollarFinal, 'grams' => $grams, 'vendorMarkup from DB' => $responseMarkup[0]['vendorMarkup'], 'conversionRate' => $responseRate[0]['conversionRate'], 'position' => $variant_position, 'extra_parameter_saree' => $extra_parameter_saree, 'extra_parameter_lehengas' => $extra_parameter_lehengas, 'shippingMandirTrue' => $shippingMandirTrue);

			if ($compare_at_price_inr > 0) {
				$compare_at_price_usd = $compare_at_price_inr / $responseRate[0]['conversionRate'];
				$markupPriceCompareAtPrice = $compare_at_price_usd * ($responseMarkup[0]['vendorMarkup'] / 100);
				$comparAtPriceUsdFinal = ceil($compare_at_price_usd + $markupPriceCompareAtPrice + $shippingRate + $extra_parameter_saree +
					$extra_parameter_lehengas);
			} else {
				$comparAtPriceUsdFinal = '';
			}

			$dataInsert = array(
				'email' => $email,
				'vendor_user_id' => $vendorUserId,
				'vendor_name' => $vendorName,
				'image' => $image,
				'product_id' => $product_id,
				'variant_id' => $variant_id,
				'price_old' => $old_variant_price,
				'qty_old' => $old_inventory_quantity,
				'price_new' => $priceNew,
				'qty_new' => $inventory_quantity,
				'grams' => $grams,
				'created_at' => $created_at
			);

			$this->Vendororders_model->insertProductDetails($dataInsert);

			$dataUpdate = array('price' => $priceInDollarFinal, 'price_inr' => $priceNew, 'inventory_quantity' => $inventory_quantity,
				'compare_at_price' => $comparAtPriceUsdFinal, 'compare_at_price_inr' => $compare_at_price_inr, 'grams' => $grams);
			$where = array('variant_id' => $variant_id);


			$dataUpdateProduct = array('price_usd' => $priceInDollarFinal, 'price_inr' => $priceNew,
				'price_compare_at_usd' => $comparAtPriceUsdFinal, 'compare_at_price_inr' => $compare_at_price_inr);
			$whereProduct = array('product_id' => $product_id);

			if ($variant_position == 1) {
				$this->Vendororders_model->updateVariant($whereProduct, $dataUpdateProduct, 'kp_product_details');
			}

			if ($this->Vendororders_model->updateVariant($where, $dataUpdate, 'kp_variants_details')) {
				$dataApi = array('variant' => array("id" => "$variant_id", "grams" => "$grams", "inventory_quantity" => "$inventory_quantity", "price" => "$priceInDollarFinal", "compare_at_price" => $comparAtPriceUsdFinal));
				/*$dataApi = array(
					'product' => array(
						'id' => $product_id,                                       
						'variant'=> array(
							'id' => $variant_id,
							'price' => $priceInDollarFinal,
							'inventory_quantity' => $inventory_quantity,
							'old_inventory_quantity' => $old_inventory_quantity
							)
						)
				);

				$otherVariant = 'SELECT `variant_id` as `id` FROM `kp_variants_details` WHERE `product_id` = '.$product_id.' AND `variant_id` not in ('.$variant_id.') order by position;';
				$otherVariantQuery = $this->db->query($otherVariant);
				#echo $this->db->last_query();
				$otherVariantArray = $otherVariantQuery->result_array();
				$dataApi111 = array_merge($dataApi['product']['variant'],$otherVariantArray);
				$dataApi = array(
					'product' => array(
						'id' => $product_id,
						'variant'=> $dataApi111
						)
				);
				print_r($dataApi);*/
				/*exit;*/
				#$url = "https://$api_key:$api_pass@karmaplacecom.myshopify.com/admin/products/$product_id.json";
				
				$url = "https://$api_key:$api_pass@karmaplacecom.myshopify.com/admin/variants/$variant_id.json";
				$curl = curl_init($url);
				curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "PUT");
				curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($dataApi));
				curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
				curl_setopt($curl, CURLOPT_HEADER, false);
				curl_setopt($curl, CURLOPT_VERBOSE, false);
				$result = curl_exec($curl);
				curl_close($curl);

				echo json_encode(array('status' => true, 'Message' => 'Successfully Updated', 'log' => $log, 'api_msg' => $result, 'variantid' => $variant_id));
			} else {
				echo json_encode(array('status' => false, 'Message' => 'Unable to Updated'));
			}
		} else {
			//Update only quantity - Vendor login
			$inventory_quantity = $this->input->post('inventory_quantity');
			$variant_id = $this->input->post('variant_id');
			$old_inventory_quantity = $this->input->post('old_inventory_quantity');
			$image = $this->input->post('variant_image');
			$grams = $this->input->post('grams');
			$priceNew = $this->input->post('variant_price');
			$product_id = $this->input->post('product_id');
			$vendorUserId = $this->session->userdata['vendor_user_id'];
			$email = $this->session->userdata['email'];
			$vendorName = $this->session->userdata['vendor_name'];
			
			if (empty($vendorUserId)) {
				#echo 'in vendor id empty';
				$sqlVendor = 'SELECT  `vendor`.`id` 
					FROM  `kp_product_details` AS  `prods` 
					INNER JOIN  `vendorDetails` AS  `vendor` ON (  `prods`.`vendor` =  `vendor`.`vendorName` ) 
					WHERE  `prods`.`product_id` =' . $product_id;
				$sqlVendorResult = $this->db->query($sqlVendor);

				foreach ($sqlVendorResult->result() as $row) {
					$vendorUserId = $row->id;
				}
				#echo 'vendorUserId '.$vendorUserId;exit;
			}
			
			$created_at = date("F j, Y, g:i a");
			$api_key = '6817756f7b312d21867786e3ab92d8b4';
			$api_pass = '384d011b0e4e488e6e79a241821ed98b';

			$dataInsert = array(
				'email' => $email,
				'vendor_user_id' => $vendorUserId,
				'vendor_name' => $vendorName,
				'image' => $image,
				'product_id' => $product_id,
				'variant_id' => $variant_id,
				'price_old' => $priceNew,
				'qty_old' => $old_inventory_quantity,
				'price_new' => $priceNew,
				'qty_new' => $inventory_quantity,
				'grams' => $grams,
				'created_at' => $created_at
			);
			$this->Vendororders_model->insertProductDetails($dataInsert);
			
			$dataUpdate = array('inventory_quantity' => $inventory_quantity);
			$where = array('variant_id' => $variant_id);
			
			if ($this->Vendororders_model->updateVariant($where, $dataUpdate, 'kp_variants_details')) {
				
				$dataApi = array('variant' => array("id" => "$variant_id", "inventory_quantity" => "$inventory_quantity"));
				
				$url = "https://$api_key:$api_pass@karmaplacecom.myshopify.com/admin/variants/$variant_id.json";
				$curl = curl_init($url);
				curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "PUT");
				curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($dataApi));
				curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
				curl_setopt($curl, CURLOPT_HEADER, false);
				curl_setopt($curl, CURLOPT_VERBOSE, false);
				$result = curl_exec($curl);
				curl_close($curl);

				echo json_encode(array('status' => true, 'Message' => 'Successfully Updated', 'log' => $log, 'api_msg' => $result, 'variantid' => $variant_id));
			} else {
				echo json_encode(array('status' => false, 'Message' => 'Unable to Updated'));
			}
		}
    }


	public function deleteVariant()
    {
		$id = $this->input->post('variant_id');

		$query = $this->db->get_where('kp_variants_details', array('variant_id' => $id));
   		$resultData = $query->row_array();		
   		$this->db->where('variant_id', $id);
  		$this->db->delete('kp_variants_details'); 

        $data = array(
        	'variant_pk_id'=>$resultData['id'],
			'variant_id'=>$resultData['variant_id'],
			'product_id'=>$resultData['product_id'],
	        'title'=>$resultData['title'],
	        'price'=>$resultData['price'],
	        'price_inr'=>$resultData['price_inr'],
	        'sku'=>$resultData['sku'],
	        'position'=>$resultData['position'],
	        'inventory_policy'=>$resultData['inventory_policy'],
	        'compare_at_price'=>$resultData['compare_at_price'],
	        'compare_at_price_inr'=>$resultData['compare_at_price_inr'],
	        'fulfillment_service'=>$resultData['fulfillment_service'],
	        'inventory_management'=>$resultData['inventory_management'],
	        'option1'=>$resultData['option1'],
	        'option2'=>$resultData['option2'],
			'option3'=>$resultData['option3'],
	        'image_id'=>$resultData['image_id'],
			'variant_created_at'=>$resultData['variant_created_at'],
	        'variant_updated_at'=>$resultData['variant_updated_at'],
			'taxable'=>$resultData['taxable'],
	        'barcode'=>$resultData['barcode'],
			'grams'=>$resultData['grams'],
	        'weight'=>$resultData['weight'],
			'weight_unit'=>$resultData['weight_unit'],
	        'inventory_item_id'=>$resultData['inventory_item_id'],
			'inventory_quantity'=>$resultData['inventory_quantity'],
	        'old_inventory_quantity'=>$resultData['old_inventory_quantity'],
			'requires_shipping'=>$resultData['requires_shipping'],
	        'image'=>$resultData['image'],
	        'updatedBy'=>$_SESSION['email'],
	        'UpdatedIP'=>$_SERVER['REMOTE_ADDR'],
	        'updatedOn'=>date('Y-m-d H:i:s'),
	        'updateBrowser'=>$_SERVER['HTTP_USER_AGENT'],
            'action'=>'Delete',
	    );

	    $this->db->insert('kp_variants_detailslog',$data);
		
		//Remove the variant from kp_product_details
		$query2 = $this->db->get_where('kp_product_details', array('product_id' => $resultData['product_id']));
   		$resultData2 = $query2->result_array();
		
		$parts = array();
		$str = $resultData2[0]['variant_skus']; 
		$item = $resultData['sku'];
		$parts = explode(',', $str);
		while(($i = array_search($item, $parts)) !== false) {
			unset($parts[$i]);
		}
		$newstr = implode(',', $parts);
		
		//if sku has deleted variant, replace with existing one
		$whereProduct = array('product_id' => $resultData['product_id']);
		if($item == $resultData['sku']){
			$dataUpdateProduct = array('variant_skus' => $newstr, 'sku' => $parts[0]);
		} else {
			$dataUpdateProduct = array('variant_skus' => $newstr);
		}
		$this->Vendororders_model->updateVariant($whereProduct, $dataUpdateProduct, 'kp_product_details');

		//Delete from shopify
		$api_key = '6817756f7b312d21867786e3ab92d8b4';
        $api_pass = '384d011b0e4e488e6e79a241821ed98b';
		
		$variant_id = $data['variant_id'];
		$product_id = $data['product_id'];
		
		$url = "https://$api_key:$api_pass@karmaplacecom.myshopify.com/admin/products/$product_id/variants/$variant_id.json";
	    $curl = curl_init($url);
	    curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "DELETE");
	    curl_setopt($session, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($session, CURLOPT_TIMEOUT, 20);
        curl_setopt($session, CURLOPT_CONNECTTIMEOUT, 20);
	    $result = curl_exec($curl);
	    curl_close($curl);
		
		echo json_encode(array('Message' => 'Variant is deleted successfully.'));
    }
}

