<?php
defined('BASEPATH') OR exit('No direct script access allowed');
error_reporting(0);

class Products extends Admin_Controller {

  public function __construct()
  {
      parent::__construct();
      error_reporting(E_ALL & ~E_NOTICE);    

      // /* Load :: Common */
      $this->lang->load('admin/vendors');
      $this->load->model('admin/Products','adminProducts_model');
      $this->load->model('admin/Orders_model', 'adminorders_model');

      // /* Title Page :: Common */
      $this->page_title->push(lang('menu_vendors'));
       $this->data['pagetitle'] = $this->page_title->show();

      // /* Breadcrumbs :: Common */
       $this->breadcrumbs->unshift(1, lang('menu_vendors'), 'admin/vendors');
  }


	public function index()
	{
    if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
    // if ( ! $this->ion_auth->logged_in())
    {
        redirect('auth/login', 'refresh');
    }
    else
    {
        /* Breadcrumbs */
        //$this->data['breadcrumb'] = $this->breadcrumbs->show();
        $this->data['orders'] = $this->Orders_model->getOrderDetails();

        /* Load Template */
        $this->template->admin_render('admin/orders/index', $this->data);
    }
	}

	public function view()
	{
    $id = $this->uri->segment('4');

    $this->data['orders'] = $this->Orders_model->getSingleOrderDetails($id);
    $this->data['products'] = $this->Orders_model->getOrderProductDetails($id);
    $this->data['billing'] = $this->Orders_model->getBillingOrderDetails($id);
    $this->data['shipping'] = $this->Orders_model->getShippingOrderDetails($id);
    // echo "<pre>";print_r($this->data);echo "</pre>";exit;
    $this->template->admin_render('admin/orders/view', $this->data);
	}

	public function productdump()
	{
      $obj =& get_instance();     
		  $getProducts = $this->getProducts();
      
       foreach ($getProducts['products'] as $product) {
        $productId = $product['id'];
        $array_productid = array('product_id' => $productId);
        $hasProduct = $this->adminProducts_model->getProductById($productId);
              $dataProduct = array(
                    'product_id'     =>  $productId,
                    'body_html'      =>  $product['body_html'],
                    'created_at'     =>  $product['created_at'],
                    'vendor'         =>  $product['vendor'],
                    'updated_at'     =>  $product['updated_at'],
                    'product_type'   =>  $product['product_type'],
                    'handle'         =>  $product['handle'],
                    'tags'           =>  $product['tags'],
                    'published_at'   =>  $product['published_at'],
                    'product_title'  =>  $product['title'],
                    'image'          =>  $product['image']['src'],   
            );

            if($hasProduct->num_rows() >= 1)
            {
              $this->adminorders_model->update_data($array_orderid, $dataProduct, 'kp_product_details');
            }
            else
            {
              $dataProduct = array_merge($dataProduct, $array_productid);
              $this->db->insert('kp_product_details', $dataProduct);
            }



          $obj->db->insert('kp_product_details', $dataProduct);
          foreach ($product['variants'] as $variant) {
              $dataVariant = array(
                    'variant_id'     =>  $variant['id'],
                    'product_id'     =>  $variant['product_id'],
                    'title'          =>  $variant['title'],
                    'price'          =>  $variant['price'],
                    'sku'            =>  $variant['sku'],
                    'position'       =>  $variant['position'],
                    'inventory_policy'     =>  $variant['inventory_policy'],
                    'compare_at_price'     =>  $variant['compare_at_price'],
                    'fulfillment_service'  =>  $variant['fulfillment_service'],
                    'inventory_management' =>  $variant['inventory_management'],
                    'option1'     =>  $variant['option1'],
                    'option2'     =>  $variant['option2'],
                    'option3'     =>  $variant['option3'],
                    'created_at'  =>  $variant['created_at'],
                    'updated_at'  =>  $variant['updated_at'],
                    'taxable'     =>  $variant['taxable'], 
                    'barcode'     =>  $variant['barcode'],
                    'grams'       =>  $variant['grams'],
                    'weight'      =>  $variant['weight'],
                    'weight_unit' =>  $variant['weight_unit'],
                    'inventory_item_id'     =>  $variant['inventory_item_id'],
                    'inventory_quantity'    =>  $variant['inventory_quantity'], 
                    'old_inventory_quantity'=>  $variant['old_inventory_quantity'],
                    'requires_shipping'     =>  $variant['requires_shipping']
            );

            if($hasProduct->num_rows() >= 1)
            {
              $this->adminorders_model->update_data($array_productid, $dataVariant, 'kp_variants_details');
            }
            else
            {
              $dataProduct = array_merge($dataVariant, $array_productid);
              $this->db->insert('kp_variants_details', $dataVariant);
            }

             $obj->db->insert('kp_variants_details', $dataVariant);
          }
        }
  }

  public function Shopify( $storeURL, $apiKey, $secret ) {
      $this->__construct( $storeURL, $apiKey, $secret );
  }


  public function getProducts( $filters = array() ) {

   	  $this->_storeURL = 'karmaplacecom.myshopify.com';
      $this->_apiKey = 'ec337c22123c8c7ba33be795e851137a';
      $this->_secret = 'bf8822fc9fa0cbd128ca7ba731015a10';

      $filter[] = "";
      foreach ( $filters as $key=>$value ) {
          $filter[] = "{$key}=".urlencode($value);
      }
      $url = "https://" . "{$this->_apiKey}:{$this->_secret}@{$this->_storeURL}" ."/admin/products.xml".(count($filter)?'?'.join('&',$filter):'');
      
      $session = curl_init();
      curl_setopt($session, CURLOPT_URL, "https://ec337c22123c8c7ba33be795e851137a:bf8822fc9fa0cbd128ca7ba731015a10@karmaplacecom.myshopify.com/admin/products.json?page=2");
      curl_setopt($session, CURLOPT_RETURNTRANSFER, TRUE);
      curl_setopt($session, CURLOPT_TIMEOUT, 20);
      curl_setopt($session, CURLOPT_CONNECTTIMEOUT, 20);
      $res      = curl_exec($session);
      $products = json_decode($res, true);
       return $products;
  }
      
  public function _getDOM( $xmlDoc ) {
      if( function_exists("domxml_open_mem") )
          return domxml_open_mem( $xmlDoc );
      else if ( method_exists("DOMDocument","loadXML") )
          return DOMDocument::loadXML( $xmlDoc );
      else
          return null;
  }
  
  public function _xpath( $dom, $query ) {
      if ( method_exists( $dom, "xpath_new_context" ) ) {
          $xpath = $dom->xpath_new_context();
          return $xpath->xpath_eval("/orders/order");
      } else if ( class_exists( "DOMXPath" ) ) {
          $xpath = new DOMXPath( $dom );
          return $xpath->query( $query );
      } else {
          return null;
      }
  }
  
  public function _xmlToArray( $xmlNode ) {
      $result = array();
      if ( method_exists($xmlNode,"child_nodes") ) {
          foreach ( $xmlNode->child_nodes() as $childNode ) {
              if ( $childNode->node_name() == '#text' )
                  ;//Do nothing
              else if ( count($childNode->child_nodes())<2 )
                  $result[$childNode->node_name()] = $childNode->get_content();
              else 
                  $xmlNode->get_attribute('type') == "array" ? 
                      $result[] = $this->_xmlToArray( $childNode ) :
                      $result[$childNode->node_name()] = $this->_xmlToArray( $childNode );
          }
      } else if ( isset($xmlNode->nodeName) ) {
          foreach ( $xmlNode->childNodes as $childNode ) {
              if ( $childNode->nodeName == '#text' )
                  ;//Do nothing
              else if ( $childNode->childNodes->length<2 )
                  $result[$childNode->nodeName] = $childNode->nodeValue;
              else 
                  $xmlNode->getAttribute('type') == "array" ? 
                      $result[] = $this->_xmlToArray( $childNode ) :
                      $result[$childNode->nodeName] = $this->_xmlToArray( $childNode );
          }
      }
      return $result;
  }

}
