<?php
defined('BASEPATH') OR exit('No direct script access allowed');
require_once APPPATH."/third_party/ShopifyAPI/autoload.php";
require_once APPPATH."third_party/html2pdf.php";
include(APPPATH.'PHPExcel-1.8/Classes/PHPExcel/IOFactory.php');
error_reporting(E_ALL ^ E_NOTICE);

class Orders extends Admin_Controller
{
    public function __construct()
    {
        parent::__construct();
        #error_reporting(E_ALL & ~E_NOTICE);
        // /* Load :: Common */
        $this->lang->load('admin/vendors');
        $this->load->model('admin/Orders_model');
        $this->load->model('Vendororders_model');
        $this->load->model('Products_model');
        $this->load->library('email');
        // $this->load->model('admin/Orders_model');


        // /* Title Page :: Common */
        $this->page_title->push(lang('menu_vendors'));
        $this->data['pagetitle'] = $this->page_title->show();
        // /* Breadcrumbs :: Common */
        $this->breadcrumbs->unshift(1, lang('menu_vendors'), 'admin/vendors');
    }

    public function createproducts()
    {
        $this->data['title'] = 'Create products';
        $this->template->admin_render('admin/products/listfiles', $this->data);
    }

    public function productdelete()
    {
      $productId = $this->uri->segment('4');

      $this->_storeURL = 'karmaplacecom.myshopify.com';
      $this->_apiKey = 'ec337c22123c8c7ba33be795e851137a';
      $this->_secret = 'bf8822fc9fa0cbd128ca7ba731015a10';

      $session = curl_init();
      curl_setopt($session, CURLOPT_URL, "https://ec337c22123c8c7ba33be795e851137a:bf8822fc9fa0cbd128ca7ba731015a10@karmaplacecom.myshopify.com/admin/products/".$productId.".json");
      curl_setopt($session, CURLOPT_CUSTOMREQUEST, "DELETE");
      curl_setopt($session, CURLOPT_RETURNTRANSFER, TRUE);
      curl_setopt($session, CURLOPT_TIMEOUT, 20);
      curl_setopt($session, CURLOPT_CONNECTTIMEOUT, 20);
      $res      = curl_exec($session);
      // $products = json_decode($res, true);
      // echo "<pre>";print_r($products);

        $this->Products_model->deleteProductMain($productId);
        $this->Products_model->deleteProductVariant($productId);

        $this->data['title'] = 'Delete products';
        $this->data['message'] = 'Products deleted successfully on Shopify!';
        // $this->load->view('admin/orders/productsadmin', $this->data);
        $this->template->admin_render('admin/products/productsadmin', $this->data);
    }

     public function getProducts( $filters = array() ) {

      $this->_storeURL = 'karmaplacecom.myshopify.com';
      $this->_apiKey = 'ec337c22123c8c7ba33be795e851137a';
      $this->_secret = 'bf8822fc9fa0cbd128ca7ba731015a10';

      $filter[] = "";
      foreach ( $filters as $key=>$value ) {
          $filter[] = "{$key}=".urlencode($value);
      }
      $url = "https://" . "{$this->_apiKey}:{$this->_secret}@{$this->_storeURL}" ."/admin/products.xml".(count($filter)?'?'.join('&',$filter):'');
      
      $session = curl_init();
      // curl_setopt($session, CURLOPT_URL, "https://ec337c22123c8c7ba33be795e851137a:bf8822fc9fa0cbd128ca7ba731015a10@karmaplacecom.myshopify.com/admin/products.json?page=10");
      curl_setopt($session, CURLOPT_URL, "https://ec337c22123c8c7ba33be795e851137a:bf8822fc9fa0cbd128ca7ba731015a10@karmaplacecom.myshopify.com/admin/products/2027912527969.json");
      curl_setopt($session, CURLOPT_RETURNTRANSFER, TRUE);
      curl_setopt($session, CURLOPT_TIMEOUT, 20);
      curl_setopt($session, CURLOPT_CONNECTTIMEOUT, 20);
      $res      = curl_exec($session);
      $products = json_decode($res, true);
      echo "<pre>";print_r($products);exit;

  }

    // public function array_search_recursive($needle, array $haystack)
    // {
    //     foreach ($haystack as $key => $value) {
    //         $current_key = $key;

    //         if ($needle === $value or (is_array($value) && $this->array_search_recursive($needle, $value) !== false)) {
    //             return $current_key;
    //         }
    //     }
    //     return false;
    // }

    function array_search_recursive($srchvalue, $array)
    {
        if (is_array($array) && count($array) > 0)
        {
            $foundkey = array_search($srchvalue, $array);
            if ($foundkey === FALSE)
            {
                foreach ($array as $key => $value)
                {
                    if (is_array($value) && count($value) > 0)
                    {
                        $foundkey = $this->array_search_recursive($srchvalue, $value);
                        if ($foundkey != FALSE)
                            return $foundkey;
                    }
                }
            }
            else
                return $foundkey;
        }
    }




    public function shopifyCreateProducts()
    {
        $this->_storeURL = 'karmaplacecom.myshopify.com';
        $this->_apiKey = 'ec337c22123c8c7ba33be795e851137a';
        $this->_secret = 'bf8822fc9fa0cbd128ca7ba731015a10';

        $file_name = $this->uri->segment('4');
        $inputFileName = "/var/www/html/kptracking/pricecalc/csvfiles_updated/".$file_name;

        try{
            $inputFileType = PHPExcel_IOFactory::identify($inputFileName);
            $objReader     = PHPExcel_IOFactory::createReader($inputFileType);
            $objPHPExcel   = $objReader->load($inputFileName);
        } catch (Exception $e) {
            die('Error loading file "' . pathinfo($inputFileName, PATHINFO_BASENAME) . '": ' . 
            $e->getMessage());
        }

        $sheet = $objPHPExcel->getSheet(0);
        $objPHPExcel->setActiveSheetIndex(0);

        $highestRow = $sheet->getHighestRow();
        $highestColumn = $sheet->getHighestColumn();

        //$i=1;
        $dataVariant  = array();
        $variantImage = array();
        $variantImageIndexCheck = array();
        $dataImage    = array();
        $productImage = array();
        $productImageIndexCheck = array();
        $arrOptions = array();
        $productOption = array();
        $productOptionIndexCheck = array();

        for ($row = $highestRow; $highestRow >= 1; $row--) {

                if($row == 1){
                    break;
                }
                

                $rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, null, true, false);

                if($rowData[0][1] =='' && $rowData[0][3] !=''){

                      $dataVariants = $rowData[0];

                      // if($dataVariants['43'] !=''){
                      //     $variantImageIndexCheck[] = array("id"=>$row);
                      // }

                      // $variantImage[] = array("variant_image"=>$dataVariants['24']);


                      if($dataVariants['43'] !=''){
                          $variantImageIndexCheck[] = array("id"=>$row);
                          $variantImage[] = array("variant_image"=>$dataVariants['24'],"id"=>$row, "variant_img"=>$dataVariants['43']);
                          // echo $row."<br/>";
                      }else{
                          $variantImage[] = array("variant_image"=>$dataVariants['24']);
                      }

                      if($dataVariants['8'] !=''){
                          $variantOptionIndexCheck[] = array("id"=>$row);
                          $variantOption[] = array("option"=>$dataVariants['8'],"id"=>$row, "variant_img"=>$dataVariants['43']);
                          // echo $row."<br/>";
                      }

                  //echo "<pre>";print_r($variantImage); exit;

                  if($dataVariants['17'] !="" && $dataVariants['18'] !=""){
                          $dataVariant[] = array(
                                            "handle"=>$dataVariants['0'],
                                            "vendor"=>$dataVariants['3'],
                                            "option1"=>$dataVariants['8'],
                                            "option2"=>$dataVariants['10'],
                                            "option3"=>$dataVariants['12'],
                                            "sku"=>$dataVariants['13'],
                                            "grams"=>$dataVariants['14'],
                                            "inventory_management"=>$dataVariants['15'],
                                            "inventory_quantity"=>$dataVariants['16'],
                                            "inventory_policy"=>$dataVariants['17'],
                                            "fulfillment_service"=>$dataVariants['18'],
                                            "price"=>$dataVariants['19'],
                                            "compare_at_price"=>$dataVariants['20'],
                                            "requires_shipping"=>$dataVariants['21'],
                                            "taxable"=>$dataVariants['22'],
                                            // "variant_image"=>$dataVariants['43'],
                                            "weight_unit"=>$dataVariants['44']
                                    );
                  }else{
                          $dataVariant[] = array(
                                            "handle"=>$dataVariants['0'],
                                            "vendor"=>$dataVariants['3'],
                                            "option1"=>$dataVariants['8'],
                                            "option2"=>$dataVariants['10'],
                                            "option3"=>$dataVariants['12'],
                                            "sku"=>$dataVariants['13'],
                                            "grams"=>$dataVariants['14'],
                                            "inventory_management"=>$dataVariants['15'],
                                            "inventory_quantity"=>$dataVariants['16'],
                                            "price"=>$dataVariants['19'],
                                            "compare_at_price"=>$dataVariants['20'],
                                            "requires_shipping"=>$dataVariants['21'],
                                            "taxable"=>$dataVariants['22'],
                                            // "variant_image"=>$dataVariants['43'],
                                            "weight_unit"=>$dataVariants['44']
                                    );
                  }
                      

                // }elseif($rowData[0][1] =='' && $rowData[0][3] ==''){

                //       $dataImagesProduct = $rowData[0];
                //       $dataImageProducts[] = array( 
                //                                     "image" => array(
                //                                             "src" => $dataImagesProduct['24']
                //                                     )
                //                              );
                }else{

                      $dataVariants = $rowData[0];

                      if($dataVariants['43'] !=''){
                          $variantImageIndexCheck[] = array("id"=>$row);
                          $variantImage[] = array("variant_image"=>$dataVariants['24'],"id"=>$row);
                          // echo $row."<br/>";
                      }else{
                          $variantImage[] = array("variant_image"=>$dataVariants['24']);
                      }

                      if($dataVariants['8'] !=''){
                          $variantOptionIndexCheck[] = array("id"=>$row);
                          $variantOption[] = array("option"=>$dataVariants['8'],"id"=>$row, "variant_img"=>$dataVariants['43']);
                          // echo $row."<br/>";
                      }

                      // echo "<pre>".$row;print_r($variantImage);  echo "/<pre>";
                      
                  if($rowData[0][1] !='' && $rowData[0][3] !=''){

                      $productData = $rowData[0];

                  // echo "<pre>";print_r($productData);echo "</pre>";
                  //echo "<pre><hr>Varient Start here->";print_r($dataVariant);echo "</pre>";
                  //echo "<pre>";print_r($dataImage);echo "</pre>";
                  //echo "<pre>";print_r($rowData);echo "</pre>";

                  // if($productData[20] ==0 || $productData[20] ==''){
                  //     $comparePrice = '';
                  // }

                  // echo $productData[1]."==".$productData[20]."==<br/>";
                  $optionArr["options"]  = array();

                   if(!empty($productData[7])) {
                      $optionArr["options"] = array( array(
                                              "name" => $productData[7]
                                              // "values" => array('0'=>'Red','1'=>'Blue','2'=>'Yellow','3'=>'Green')
                                            ));
                    }
                    if(!empty($productData[7]) && !empty($productData[9])) {
                      $optionArr["options"] = array(array(
                                              "name" => $productData[7]
                                              // "values" => array('0'=>'Red','1'=>'Blue','2'=>'Yellow','3'=>'Green')
                                            ),array(
                                              "name" => $productData[9]
                                              // "values" => array('0'=>'Red','1'=>'Blue','2'=>'Yellow','3'=>'Green')
                                            ));
                    }
                    if(!empty($productData[7])&&!empty($productData[9])&&!empty($productData[11])) {
                      $optionArr["options"] = array(array(
                                              "name" => $productData[7]
                                              // "values" => array('0'=>'Red','1'=>'Blue','2'=>'Yellow','3'=>'Green')
                                            ),array(
                                              "name" => $productData[9]
                                              // "values" => array('0'=>'Red','1'=>'Blue','2'=>'Yellow','3'=>'Green')
                                            ),array(
                                              "name" => $productData[11]
                                              // "values" => array('0'=>'Red','1'=>'Blue','2'=>'Yellow','3'=>'Green')
                                            ));
                    }

                    // $option1 = '';
                    // $option2 = '';
                    // $option3 = '';


                    // if(!empty($productData[8])) { $option1=$productData[8]; }
                    // if(!empty($productData[10]) && !empty($productData[8])) { $option1=$productData[8]; $option2=$productData[10]; }
                    // if(!empty($productData[12]) && !empty($productData[10]) && !empty($productData[8])) { $option1=$productData[8]; $option2=$productData[10]; $option3=$productData[12]; }
                    
// echo "<pre>"; print_r($productData[8]);  echo "<hr>";print_r($productData[10]); echo "<hr>";print_r($productData[12]); 
                    // echo "<hr>"; print_r($option1); echo "<hr>";print_r($option2); echo "<hr>";print_r($option3); echo "<hr>"; exit;
                  // $productImage[] = array("variant_image"=>$productData['24']);

                  if($productData['43'] !=''){
                      $productImageIndexCheck[] = array("id"=>$row);
                      $productImage[] = array("variant_image"=>$productData['24'],"id"=>$row);
                      // echo $row."<br/>";
                  }else{
                      $productImage[] = array("variant_image"=>$productData['24']);
                  }

                  if($productData['8'] !=''){
                      $productOptionIndexCheck[] = array("id"=>$row);
                      $productOption[] = array("option"=>$productData['8'],"id"=>$row, "variant_img"=>$productData['43']);
                      // echo $row."<br/>";
                  }

                  // echo "<pre><hr>FIRST: ";print_r($productOption);echo "</pre>";exit;

                  $products_arrayTmp1 = array(
                                            "product"=>array(
                                                "handle"=> $productData[0],
                                                "title"=>  $productData[1],
                                                "body_html"=> $productData[2],
                                                "vendor"=> $productData[3],
                                                "product_type"=> $productData[4],
                                                "tags"=> $productData[5],
                                                "published"=> $productData[6],
                                                // "images" => array(
                                                //       array(
                                                //           "src" => $productData[43],
                                                //           "position" => $productData[25],
                                                //       )
                                                // ),
                                                // "options" => array(
                                                //       array(
                                                //           "name" => $productData[7]
                                                //           // "values" => array('0'=>'Red','1'=>'Blue','2'=>'Yellow','3'=>'Green')
                                                //       )
                                                // ),
                                                "variants"=>array(
                                                                array(
                                                                        "title" => 'Title',
                                                                        "sku"=> $productData[13],
                                                                        "grams"=>$productData[14],
                                                                        "inventory_management"=>$productData[15],
                                                                        "inventory_quantity"=>$productData[16],
                                                                        "inventory_policy"=>$productData[17],
                                                                        "fulfillment_service"=>$productData[18],
                                                                        "price"=>$productData[19],
                                                                        "compare_at_price"=>$productData[20],                                                                
                                                                        "requires_shipping"=>$productData[21],
                                                                        "taxable"=>$productData[22],
                                                                        "weight_unit"=>$productData[44],
                                                                        "option1"=>$productData[8],
                                                                        "option2"=>$productData[10],
                                                                        "option3"=>$productData[12],
                                                                )
                                                               
                                                )

                                            )
                                        );
                        $products_array["product"] = $products_arrayTmp1["product"] + $optionArr;
                        // echo "<pre>"; print_r($products_array); print_r($$optionArr);exit;

                        if($dataVariant){
                            $dataVariant      = array_reverse($dataVariant);
                            $tmparrtst        = array_merge_recursive($products_array['product']['variants'],$dataVariant);
                            //$tmpArrayProd = $products_array;
                            $products_array['product']['variants'] =  array();
                            $arr111['variants'] = array_merge($products_array['product']['variants'], $tmparrtst);
                            $arr1['product']    = array_merge($products_array['product'], $arr111);
                            //echo "<pre>";print_r($arr1); //print_r($products_array);echo "</pre>"; exit;
                            $variantImage       = array_reverse($variantImage);
                            $arrImages          = array_merge($productImage, $variantImage);
                                                  array_shift($arrImages);

                            $variantOption      = array_reverse($variantOption);
                            $arrOptions         = array_merge($productOption, $variantOption);
                                                  array_shift($arrOptions);
                        }else{

                            $arr1 = $products_array;
                            $variantImage       = array_reverse($variantImage);
                            $arrImages          = array_merge($productImage, $variantImage);
                                                  array_shift($arrImages);

                            $variantOption      = array_reverse($variantOption);
                            $arrOptions         = array_merge($productOption, $variantOption);
                                                  array_shift($arrOptions);
                        }

                        // echo "<br/>=====================================<br/><br/>";

                        // echo "<pre>";print_r($arrOptions);echo "</pre>";


                          // echo "<pre><hr>ELSE: ";print_r($productData);echo "</pre>";

                          $url = "https://" . "{$this->_apiKey}:{$this->_secret}@{$this->_storeURL}" ."/admin/products.json";

                          $curl = curl_init();
                          curl_setopt($curl, CURLOPT_URL, $url);
                          curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
                          curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                          curl_setopt($curl, CURLOPT_VERBOSE, 0);
                          //curl_setopt($curl, CURLOPT_HEADER, 1);
                          curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "POST");
                          curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($arr1));
                          curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
                          $response = curl_exec($curl);

                          $prDtls     = json_decode($response, TRUE);
                           // print_r($prDtls);

                          $data      = json_decode($response, TRUE);

                          $productId = $data['product']['id'];
                          $variants  = $data['product']['variants'];


                          if($variantImageIndexCheck){
                              $variantImageIndexCheck      = array_reverse($variantImageIndexCheck);
                              $allImageIndex               = array_merge($productImageIndexCheck, $variantImageIndexCheck);
                          }else{
                              $allImageIndex               = $productImageIndexCheck;
                          }


                          // $var = array_shift($variants);
                          //echo "<br/>=====================================<br/><br/>";

                          // echo "<pre>";print_r($productImageIndexCheck);echo "</pre>";
                          // echo "<pre>";print_r($variantImage);echo "</pre>";
                            //echo "Line number::".$row."==<br/>";
                           // echo "<pre>";print_r($arrImages);echo "</pre>";
                            //print_r($var);echo "</pre>";
                           // echo "<br/>-------------------------------------";
                          // echo "<pre>";print_r($variantImageIndexCheck);echo "</pre>";

                         // echo "<pre>";print_r($variants);echo "</pre>";
                          //echo "<br/>-------------------------------------";
                          //echo "<pre>";print_r($allImageIndex);echo "</pre>";
                          //echo "<br/>-------------------------------------";
                          //echo "<pre>";print_r($arrImages);echo "</pre>";
                           // echo "<br/>=====================================<br/>";

                                                             // echo "<pre>";print_r($arrImages);echo "</pre>";


                          
                          if($arrImages !=''){

                              $k=0;
                              foreach ($arrImages as $dataImageProduct) {

                                if($dataImageProduct['variant_image'] != ''){

                                  $imgAll = array( 
                                                "image" => array(
                                                        "src" => $dataImageProduct['variant_image']
                                                )
                                  );

                                  $urlImageProduct = "https://" . "{$this->_apiKey}:{$this->_secret}@{$this->_storeURL}" ."/admin/products/".$productId."/images.json";
                                  $curlImageProduct = curl_init();

                                  curl_setopt($curlImageProduct, CURLOPT_URL, $urlImageProduct);
                                  curl_setopt($curlImageProduct, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
                                  curl_setopt($curlImageProduct, CURLOPT_RETURNTRANSFER, true);
                                  curl_setopt($curlImageProduct, CURLOPT_VERBOSE, 0);
                                  // curl_setopt($curl, CURLOPT_HEADER, 1);
                                  curl_setopt($curlImageProduct, CURLOPT_CUSTOMREQUEST, "POST");
                                  curl_setopt($curlImageProduct, CURLOPT_POSTFIELDS, json_encode($imgAll));
                                  curl_setopt($curlImageProduct, CURLOPT_SSL_VERIFYPEER, false);
                                  $responseImageProduct = curl_exec($curlImageProduct);

                                  $imgDtls     = json_decode($responseImageProduct, TRUE);
                                  
                                  $tmpArrImgRes[] = array($imgDtls['image']['id'] => $dataImageProduct['variant_image']);
                                  // echo "<pre>";print_r($imgDtls);print_r($tmpArrImgRes);echo "</pre>";

                                  curl_close($curlImageProduct);

                                  // if (array_key_exists("id",$dataImageProduct)){
                                  //       //echo $k."<br/>";
                                  //       // echo "<pre>";print_r($variants[$k]);echo "</pre>";
                                  //       $variantId = $variants[$k]['id'];

                                  //       if($this->array_search_recursive($dataImageProduct['variant_img'], $tmpArrImgRes))
                                  //       {
                                  //         $key = $this->array_search_recursive($dataImageProduct['variant_img'], $tmpArrImgRes);
                                  //         $imageIdttmp = array_keys($tmpArrImgRes[$key]); 
                                  //         $imageId = $imageIdttmp[0];
                                  //         //print_r($imageId); exit;
                                  //       }else{
                                  //         $imageId = $imgDtls['image']['id'];
                                  //       }


                                  //       // echo $imageId."<br/>"; 




                                  //        $variantImageAPI = array( 
                                  //                             "variant" => array(
                                  //                                 "id" => $variantId,
                                  //                                 "image_id" => $imageId
                                  //                         )
                                  //                  );

                                  //           $urlVariantImage = "https://" . "{$this->_apiKey}:{$this->_secret}@{$this->_storeURL}" ."/admin/variants/".$variantId.".json";
                                  //           $curlVariantImage = curl_init();

                                  //           curl_setopt($curlVariantImage, CURLOPT_URL, $urlVariantImage);
                                  //           curl_setopt($curlVariantImage, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
                                  //           curl_setopt($curlVariantImage, CURLOPT_RETURNTRANSFER, true);
                                  //           curl_setopt($curlVariantImage, CURLOPT_VERBOSE, 0);
                                  //           // curl_setopt($curlVariantImage, CURLOPT_HEADER, 1);
                                  //           curl_setopt($curlVariantImage, CURLOPT_CUSTOMREQUEST, "PUT");
                                  //           curl_setopt($curlVariantImage, CURLOPT_POSTFIELDS, json_encode($variantImageAPI));
                                  //           curl_setopt($curlVariantImage, CURLOPT_SSL_VERIFYPEER, false);
                                  //           $responseVariantImage = curl_exec($curlVariantImage);
                                  //           // echo "<pre>";print_r($responseVariantImage);echo "</pre>";
                                  //           curl_close($curlVariantImage);
                                  // }

                                }

                              $k++;
                              }
                          }

                        if($arrOptions != ''){

                          $z = 0;
                          foreach ($arrOptions as $option) {

                                   // echo "<pre>";print_r($option);echo "</pre>";
//echo "<pre>";

                            if (array_key_exists("id",$option)){
                                    //print_r($option['variant_img']); print_r($tmpArrImgRes); echo $z."hereFirst";

                                      if($this->array_search_recursive($option['variant_img'], $tmpArrImgRes))
                                        {
                                          // echo $z."here"."<br/>";
                                          $imageId = $this->array_search_recursive($option['variant_img'], $tmpArrImgRes);
                                          $variantId = $variants[$z]['id'];
                                          // echo "<br/>++++++++++++++++++++++<br/>";

                                            $variantImageAPI = array( 
                                                      "variant" => array(
                                                          "id" => $variantId,
                                                          "image_id" => $imageId
                                                  )
                                            );

                                            $urlVariantImage = "https://" . "{$this->_apiKey}:{$this->_secret}@{$this->_storeURL}" ."/admin/variants/".$variantId.".json";
                                            $curlVariantImage = curl_init();

                                            curl_setopt($curlVariantImage, CURLOPT_URL, $urlVariantImage);
                                            curl_setopt($curlVariantImage, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
                                            curl_setopt($curlVariantImage, CURLOPT_RETURNTRANSFER, true);
                                            curl_setopt($curlVariantImage, CURLOPT_VERBOSE, 0);
                                            // curl_setopt($curlVariantImage, CURLOPT_HEADER, 1);
                                            curl_setopt($curlVariantImage, CURLOPT_CUSTOMREQUEST, "PUT");
                                            curl_setopt($curlVariantImage, CURLOPT_POSTFIELDS, json_encode($variantImageAPI));
                                            curl_setopt($curlVariantImage, CURLOPT_SSL_VERIFYPEER, false);
                                            $responseVariantImage = curl_exec($curlVariantImage);
                                            // echo "<pre>";print_r($responseVariantImage);echo "</pre>";
                                            curl_close($curlVariantImage);

                                    }
                            }

                            $z++;
                          }

                        }

                          // echo "<pre>";print_r($arrOptions);echo "</pre>";
                          // echo "<pre>";print_r($variants);echo "</pre>";
                          // echo "<br/>-------------------------------------<br/>";
                          // echo "<pre>";print_r($tmpArrImgRes);echo "</pre>";

                          // echo "<br/>=====================================<br/>";

                         // echo "<pre>";print_r($variantImage);
        /*                  foreach ($variantImage as $keyimg => $valueimg) {
                            # code...
                            echo $keyimg . " == " .$valueimg;
                            echo "<pre>"; print_r($valueimg);
                            echo "PP: ". $valueimg['variant_image'];
                          } */

                          //echo "<pre>"; print_r($variants); print_r($variantImage);echo "</pre>";
//exit; 
/*cho count($variants);*/

                          // $j = 0;
                          // foreach ($variants as $variant) {

                          //       $variantId =  $variant['id'];

                          //       // echo $j."<br/>";
                          //       // echo "<pre>PP:: ";print_r($variantImage[$j]['variant_image']);echo ":: KK</pre>";
                          //       //if($j == 0){
                          //       //}else{


                          //               if($arrImages !=''){
                          //                 $imageValue = $arrImages[$j]['variant_image'];
                          //               }
                          //               //echo $imageValue."<img src='".$imageValue."' width='20' height='200'><br/>";

                          //               $img = array( 
                          //                             "image" => array(
                          //                                     "src" => $imageValue
                          //                             )
                          //               );

                          //               $urlImage = "https://" . "{$this->_apiKey}:{$this->_secret}@{$this->_storeURL}" ."/admin/products/".$productId."/images.json";
                          //               $curlImage = curl_init();

                          //               curl_setopt($curlImage, CURLOPT_URL, $urlImage);
                          //               curl_setopt($curlImage, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
                          //               curl_setopt($curlImage, CURLOPT_RETURNTRANSFER, true);
                          //               curl_setopt($curlImage, CURLOPT_VERBOSE, 0);
                          //               // curl_setopt($curl, CURLOPT_HEADER, 1);
                          //               curl_setopt($curlImage, CURLOPT_CUSTOMREQUEST, "POST");
                          //               curl_setopt($curlImage, CURLOPT_POSTFIELDS, json_encode($img));
                          //               curl_setopt($curlImage, CURLOPT_SSL_VERIFYPEER, false);
                          //               $responseImage = curl_exec($curlImage);
                          //               $dataImages     = json_decode($responseImage, TRUE);

                          //               foreach ($dataImages as $dataImage) {

                          //                   $imageId = $dataImage['id'];

                          //                   $variantImageAPI = array( 
                          //                                     "variant" => array(
                          //                                         "id" => $variantId,
                          //                                         "image_id" => $imageId
                          //                                 )
                          //                          );

                          //                   $urlVariantImage = "https://" . "{$this->_apiKey}:{$this->_secret}@{$this->_storeURL}" ."/admin/variants/".$variantId.".json";
                          //                   $curlVariantImage = curl_init();

                          //                   curl_setopt($curlVariantImage, CURLOPT_URL, $urlVariantImage);
                          //                   curl_setopt($curlVariantImage, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
                          //                   curl_setopt($curlVariantImage, CURLOPT_RETURNTRANSFER, true);
                          //                   curl_setopt($curlVariantImage, CURLOPT_VERBOSE, 0);
                          //                   // curl_setopt($curlVariantImage, CURLOPT_HEADER, 1);
                          //                   curl_setopt($curlVariantImage, CURLOPT_CUSTOMREQUEST, "PUT");
                          //                   curl_setopt($curlVariantImage, CURLOPT_POSTFIELDS, json_encode($variantImageAPI));
                          //                   curl_setopt($curlVariantImage, CURLOPT_SSL_VERIFYPEER, false);
                          //                   $responseVariantImage = curl_exec($curlVariantImage);
                          //                   // echo "<pre>";print_r($responseVariantImage);echo "</pre>";
                          //                   curl_close($curlVariantImage);

                          //               }
                          //       //}        
                          //   $j++;
                          // }
                            //echo "<pre>";print_r($arr1); //print_r($tmpArrayProd);print_r($products_array);echo "</pre>";
                          unset($arr1);
                          unset($dataVariant);
                          unset($variantImage);
                          unset($variantImageIndexCheck);
                          unset($dataImageProducts);
                          unset($productImage);
                          unset($productImageIndexCheck);
                          unset($arrOptions);
                          unset($productOption);
                          unset($variantOption);
                          unset($tmpArrImgRes);

                      }

                  }
                  //$i++;
           }


        $obj =& get_instance();
        $obj->db->where("file_name",$file_name);
        $obj->db->update("kp_price_calc_files",array("process_date"=>date('Y-m-d H:i:s'),"status"=>"Processed"));
        curl_close($curl);

        $this->data['title'] = 'Create products';
        $this->data['message'] = 'Products created successfully on Shopify!';
        $this->template->admin_render('admin/products/listfiles', $this->data);

    }



    public function createpo()
    {
          //Load the library
        $this->load->library('html2pdf');
        
        //Set folder to save PDF to
        $this->html2pdf->folder('/var/www/html/kptracking/pricecalc/pdfs/');

        //Set the filename to save/download as
        $this->html2pdf->filename('mnngg.pdf');
        
        //Set the paper defaults
        $this->html2pdf->paper('a4', 'portrait');
        
        $data = array(
            'title' => 'PDF Created',
            'message' => 'Hello World!'
        );
        
        //Load html view
        $this->html2pdf->html($this->load->view('pdf', $data, true));
        
        if($this->html2pdf->create('save')) {
            //PDF was successfully saved or downloaded
            echo 'PDF saved';
        }
    }

    public function index()
    {
        if (!$this->ion_auth->logged_in() OR !$this->ion_auth->is_admin()) // if ( ! $this->ion_auth->logged_in())
        {
            redirect('auth/login', 'refresh');
        }
        else
        {
            /* Breadcrumbs */
            $this->data['orders'] = $this->Orders_model->getOrderDetails();
            /* Load Template */
            $this->template->admin_render('admin/orders/index', $this->data);
        }
    }

    public function ajaxview()
    {
        if (!$this->ion_auth->logged_in() OR !$this->ion_auth->is_admin()) // if ( ! $this->ion_auth->logged_in())
        {
            redirect('auth/login', 'refresh');
        } else {
            /* Breadcrumbs */
            //$this->data['breadcrumb'] = $this->breadcrumbs->show();
            $this->data['orders'] = $this->Orders_model->getOrderDetails();
            echo $this->data['orders'];
        }
    }

    public function productedit()
    {
        $productId = $this->uri->segment('4');
        $this->data['product'] = $this->Vendororders_model->getVendorSingleProduct($productId);
        $this->data['variant'] = $this->Vendororders_model->getVendorSingleProductVariant($productId);
        #echo "<pre>";print_r($this->data['variant']);exit;
        $this->template->admin_render('vendor/productedit', $this->data);
    }

    //  public function producteditvendor()
    // {
    //              $this->data['prod'] = '';

    //     $this->template->admin_render('vendor/producteditvendor', $this->data);
    // }

    public function products()
    {
        //$this->data['products'] = $this->Vendororders_model->getVendorProducts();
         $this->data['prod'] = '';
         $this->template->admin_render('vendor/products', $this->data);
    }

    public function productsadmin()
    {
         if (!$this->ion_auth->logged_in() OR !$this->ion_auth->is_admin()) // if ( ! $this->ion_auth->logged_in())
        {
            redirect('auth/login', 'refresh');
        }
        else
        {
            $this->template->admin_render('admin/products/productsadmin', $this->data);
        }
    }

    public function view($id = 0)
    {
        #$id = $this->uri->segment('4');

        $this->data['orders'] = $this->Orders_model->getSingleOrderDetails($id);        
        $this->data['products'] = $this->Orders_model->getOrderProductDetails($id);
        $this->data['billing'] = $this->Orders_model->getBillingOrderDetails($id);
        $this->data['shipping'] = $this->Orders_model->getShippingOrderDetails($id);
        /*$order_id = $this->data['orders']['order_id'];
        $sql = "SELECT * FROM `kp_order_product_details` AS `order_prods`
                LEFT JOIN `kp_product_details` AS `prods` on (`order_prods`.`product_id` = `prods`.`product_id`)
                WHERE `order_prods`.`order_id` = ".$order_id.";";
        $this->data['sql'] = $sql;
        $sql_result = $this->db->query($sql);
        $this->data['product_data'] = $sql_result->result_array();*/
        $this->template->admin_render('admin/orders/view', $this->data);

    }

    public function viewvendor($id = 0)
    {
        #$id = $this->uri->segment('4');
        $this->data['orders'] = $this->Orders_model->getSingleOrderDetails($id);
        $this->data['products'] = $this->Orders_model->getOrderProductDetails($id);
        #echo $this->db->last_query();exit;
        $this->data['billing'] = $this->Orders_model->getBillingOrderDetails($id);
        $this->data['shipping'] = $this->Orders_model->getShippingOrderDetails($id);
        $this->data['vendorname'] = trim($_SESSION['vendor_name']);

         // echo "here";
         //        echo "<pre>";print_r($this->data['products']);
         //        exit;

                
        $this->template->admin_render('admin/orders/viewvendor', $this->data);
    }

    public function orderEmailsVendor($order,$product){

        $data['order']    = $order;
        $data['product'] = $product;

        $data['data'] = $data;

        // prepare email
        $this->email
            ->from('info@example.com', 'Karma Place')
            ->to('avinash@ibhejo.com')
            ->subject('New KARMAPLACE Order Received!')
            // ->message('Hello, We are <strong>Example Inc.</strong>')
            ->message($this->load->view('admin/orders/order_email_vendors', $data, true))
            ->set_mailtype('html');

        // send email
        $this->email->send();
    }

    public function orderEmailsAdmin($order,$products,$billing,$shipping){

        $data['order']    = $order;
        $data['products'] = $products;
        $data['billing'] = $billing;
        $data['shipping'] = $shipping;

        $data['data'] = $data;

        // prepare email
        $this->email
            ->from('info@example.com', 'Karma Place')
            ->to('avinash@ibhejo.com')
            ->subject('Order Confirmation')
            // ->message('Hello, We are <strong>Example Inc.</strong>')
            ->message($this->load->view('admin/orders/order_email_admin', $data, true))
            ->set_mailtype('html');

        // send email
        $this->email->send();
    }

    public function orderdump()
    {
        $orders = $this->getOrders();
           // echo '<pre>'; print_r($orders ); echo '</pre>';exit;
        foreach ($orders as $order) {
           echo '<pre>'; print_r($order); echo '</pre>';

            $vendorsFinal = '';

            if (isset($order['discount-applications']['0']['value']) && $order['discount-applications']['0']['value'] != '') {
                $discount_value = $order['discount-applications']['0']['value'];
            } else {
                $discount_value = 0;
            }

            if (isset($order['discount-applications']['0']['code']) && $order['discount-applications']['0']['code'] != '') {
                $discount_code = $order['discount-applications']['0']['code'];
            } else {
                $discount_code = '';
            }

            $orderId = str_replace("#", "", $order['name']);
            $array_orderid = array('order_id' => $orderId);
            $hasOrder = $this->Orders_model->getOrderById($orderId,'kp_order_details');

            $dataBilling = array(
                'first_name' => $order['billing-address']['first-name'],
                'last_name' => $order['billing-address']['last-name'],
                'address1' => $order['billing-address']['address1'],
                'phone' => $order['billing-address']['phone'],
                'city' => $order['billing-address']['city'],
                'zip' => $order['billing-address']['zip'],
                'province' => $order['billing-address']['province'],
                'country' => $order['billing-address']['country'],
                'last_name' => $order['billing-address']['last-name'],
                'address2' => $order['billing-address']['address2'],
                'company' => $order['billing-address']['company'],
                'name' => $order['billing-address']['name'],
                'country_code' => $order['billing-address']['country-code'],
                'province_code' => $order['billing-address']['province-code']
            );

            $dataShipping = array(
                'first_name' => $order['shipping-address']['first-name'],
                'last_name' => $order['billing-address']['last-name'],
                'address1' => $order['shipping-address']['address1'],
                'phone' => $order['shipping-address']['phone'],
                'city' => $order['shipping-address']['city'],
                'zip' => $order['shipping-address']['zip'],
                'province' => $order['shipping-address']['province'],
                'country' => $order['shipping-address']['country'],
                'last_name' => $order['shipping-address']['last-name'],
                'address2' => $order['shipping-address']['address2'],
                'company' => $order['shipping-address']['company'],
                'name' => $order['shipping-address']['name'],
                'country_code' => $order['shipping-address']['country-code'],
                'province_code' => $order['shipping-address']['province-code']
            );
            
            $vendors = '';

            if($order['fulfillments']){
              foreach ($order['fulfillments'] as $fulfillment) {
                  $status = $fulfillment['status'];
                  $shipment_status = $fulfillment['shipment-status'];
              }
            }

            foreach ($order['line-items'] as $product) {

                $dataProduct = array(
                    'product_id' => $product['product-id'],
                    'status' =>  $status,
                    'created_at' => $order['created-at'],
                    'shipment_status' => $shipment_status,
                    // 'service' =>  $product['gateway'],
                    'updated_at' => $order['updated-at'],
                    // 'tracking_company' =>  $product['subtotal-price'],
                    'shipment_status' => $product['total-weight'],
                    // 'location_id' =>  $product['total-tax'],
                    // 'tracking_number' =>  $product['taxes-included'],
                    // 'tracking_url' =>  $product['currency'],
                    // 'name' =>  $product['financial-status'],

                    'referring_site' => $order['referring_site'],
                    'item_id' => $product['product-id'],
                    'product_variant_id' => $product['variant-id'],
                    'product_title' => $product['title'],
                    'product_quantity' => $product['quantity'],
                    'product_price' => $product['price'],
                    'product_sku' => $product['sku'],
                    'product_variant_title' => $product['variant-title'],
                    'product_vendor' => $product['vendor'],
                    'product_fulfillment_service' => $product['fulfillment-service'],
                    'product_product_id' => $product['product-id'],
                    'product_requires_shipping' => $product['requires-shipping'],
                    'product_taxable' => $product['taxable'],
                    'product_gift_card' => $product['gift-card'],
                    'product_name' => $product['name'],
                    'product_variant_inventory_management' => $product['variant-inventory-management'],
                    // 'product_properties' =>  $product['properties'],
                    'product_product_exists' => $product['product-exists'],
                    'product_fulfillable_quantity' => $product['fulfillable-quantity'],
                    'product_grams' => $product['grams'],
                    'product_total_discount' => $product['total-discount'],
                    'product_fulfillment_status' => $product['fulfillment-status'],
                    'product_price_set_amount' => $product['price-set']['shop-money']['amount'],
                    'product_price_set_currency_code' => $product['price-set']['shop-money']['currency-code'],
                    'product_total_discount_set_amount' => $product['total-discount-set']['shop-money']['amount'],
                    'product_total_discount_set_currency_code' => $product['total-discount-set']['shop-money']['currency-code']
                    // 'discount_allocations' =>  $product['discount-allocations'],
                    // 'product_tax_lines_title' =>  $product['subtotal-price'],
                    // 'product_tax_lines_price' =>  $product['total-weight'],
                    // 'product_tax_lines_rate' =>  $product['total-tax'],
                    // 'product_tax_lines_currency_code' =>  $product['taxes-included'],
                );

                $vendors .= $product['vendor'] . ',';

                if($hasOrder->num_rows() >= 1)
                {
                  //$this->adminorders_model->update_data($array_orderid, $dataProduct, 'kp_order_product_details');
                }
                else
                {
                  $dataProduct = array_merge($dataProduct, $array_orderid);
                  //$this->db->insert('kp_order_product_details', $dataProduct);
                }  
                //$this->orderEmailsVendor($order,$product);              
            }
            

            $vendorsFinal = rtrim($vendors, ",");

            $dataOrder = array(
                'email' => $order['email'],
                'shopify_order_id' => $order['id'],
                'customer_id' => $order['customer']['id'],
                'created_at' => $order['created-at'],
                'updated_at' => $order['updated-at'],
                'gateway' => $order['gateway'],
                'vendors' => $vendorsFinal,
                'total_price' => $order['total-price'],
                'subtotal_price' => $order['subtotal-price'],
                'total_weight' => $order['total-weight'],
                'total_tax' => $order['total-tax'],
                'taxes_included' => $order['taxes-included'],
                'currency' => $order['currency'],
                'financial_status' => $order['financial-status'],
                'confirmed' => $order['confirmed'],
                'total_discounts' => $order['total-discounts'],
                'total_line_items_price' => $order['total-line-items-price'],
                'cart_token' => $order['cart-token'],
                'buyer_accepts_marketing' => $order['buyer-accepts-marketing'],
                'name' => $order['name'],
                'cancelled_at' => $order['cancelled-at'],
                'total_price_usd' => $order['total-price-usd'],
                'checkout_token' => $order['checkout-token'],
                'processed_at' => $order['processed-at'],
                'order_number' => $order['order-number'],
                'discount_value' => $discount_value,
                'discount_code' => $discount_code,
                'payment_gateway_name' => $order['payment-gateway-name'],
                'processing_method' => $order['processing-method'],
                'checkout_id' => $order['checkout-id'],
                'fulfillment_status' => $order['fulfillment-status'],
                'rate' => $order['rate'],
                'tax_title' => $order['title'],
                'contact_email' => $order['contact-email'],
                'total_shipping' => $order['total-shipping-price-set']['shop-money']['amount']
            );
            
            if($hasOrder->num_rows() >= 1)
            {
              //$this->Orders_model->update_data($array_orderid, $dataBilling, 'kp_billing_details');
             // $this->Orders_model->update_data($array_orderid, $dataShipping, 'kp_shipping_details');
              //$this->Orders_model->update_data($array_orderid, $dataOrder, 'kp_order_details');
            }
            else
            {
              $dataBilling = array_merge($dataBilling, $array_orderid);
              $dataShipping = array_merge($dataShipping, $array_orderid);
              $dataOrder = array_merge($dataOrder, $array_orderid);

              //$this->db->insert('kp_billing_details', $dataBilling);
             // $this->db->insert('kp_shipping_details', $dataShipping);
              //$this->db->insert('kp_order_details', $dataOrder);
            }

            //$this->orderEmailsAdmin($order,$order['line-items'],$dataBilling,$dataShipping);              

            unset($product,$dataBilling,$dataShipping,$dataOrder,$orderId,$vendors,$array_orderid,$hasOrder,$orders);

           exit;

        }
    }

    public function Shopify($storeURL, $apiKey, $secret)
    {
        $this->__construct($storeURL, $apiKey, $secret);
    }

    public function getOrders($filters = array())
    {

        $this->_storeURL = 'karmaplacecom.myshopify.com';
        $this->_apiKey = 'ec337c22123c8c7ba33be795e851137a';
        $this->_secret = 'bf8822fc9fa0cbd128ca7ba731015a10';

        $filter[] = "";
        foreach ($filters as $key => $value) {
            $filter[] = "{$key}=" . urlencode($value);
        }
        $url = "https://" . "{$this->_apiKey}:{$this->_secret}@{$this->_storeURL}" .
            "/admin/orders.xml" . (count($filter) ? '?' . join('&', $filter) : '');

        $session = curl_init();
        curl_setopt($session, CURLOPT_URL, $url);
        curl_setopt($session, CURLOPT_HTTPGET, 1);
        curl_setopt($session, CURLOPT_HEADER, false);
        curl_setopt($session, CURLOPT_HTTPHEADER, array('Accept: application/xml', 'Content-Type: application/xml'));
        curl_setopt($session, CURLOPT_RETURNTRANSFER, true);

        //if(ereg("^(https)",$url)) curl_setopt($session,CURLOPT_SSL_VERIFYPEER,false);
        //echo "ssgdffdg";exit;

        $this->xml = curl_exec($session);
        curl_close($session);

        $xml = $this->_getDOM($this->xml);
        $result = $this->_xpath($xml, "/orders/order");

        $orders = array();
        if (isset($result->nodeset)) {
            foreach ($result->nodeset as $orderNode) {
                $orders[] = $this->_xmlToArray($orderNode);
            }
        } else {
            foreach ($result as $orderNode) {
                $orders[] = $this->_xmlToArray($orderNode);
            }
        }
        return $orders;
    }

    public function _getDOM($xmlDoc)
    {
        if (function_exists("domxml_open_mem"))
            return domxml_open_mem($xmlDoc);
        else if (method_exists("DOMDocument", "loadXML"))
            return DOMDocument::loadXML($xmlDoc);
        else
            return null;
    }

    public function _xpath($dom, $query)
    {
        if (method_exists($dom, "xpath_new_context")) {
            $xpath = $dom->xpath_new_context();
            return $xpath->xpath_eval("/orders/order");
        } else if (class_exists("DOMXPath")) {
            $xpath = new DOMXPath($dom);
            return $xpath->query($query);
        } else {
            return null;
        }
    }

    public function _xmlToArray($xmlNode)
    {
        $result = array();
        if (method_exists($xmlNode, "child_nodes")) {
            foreach ($xmlNode->child_nodes() as $childNode) {
                if ($childNode->node_name() == '#text')
                    ;//Do nothing
                else if (count($childNode->child_nodes()) < 2)
                    $result[$childNode->node_name()] = $childNode->get_content();
                else
                    $xmlNode->get_attribute('type') == "array" ?
                        $result[] = $this->_xmlToArray($childNode) :
                        $result[$childNode->node_name()] = $this->_xmlToArray($childNode);
            }
        } else if (isset($xmlNode->nodeName)) {
            foreach ($xmlNode->childNodes as $childNode) {
                if ($childNode->nodeName == '#text')
                    ;//Do nothing
                else if ($childNode->childNodes->length < 2)
                    $result[$childNode->nodeName] = $childNode->nodeValue;
                else
                    $xmlNode->getAttribute('type') == "array" ?
                        $result[] = $this->_xmlToArray($childNode) :
                        $result[$childNode->nodeName] = $this->_xmlToArray($childNode);
            }
        }
        return $result;
    }
}
