<?php

defined('BASEPATH') OR exit('No direct script access allowed');
error_reporting(0);
ini_set('DISPLAY_ERRORS', 0);

class Kpin_cron extends CI_Controller {

    private $_kpin_storeURL = 'ibhejo-com.myshopify.com';
    private $_kpin_apiKey = 'e127c7e88267fc70f92d48034407d2ea';
    private $_kpin_secret = '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';

    public function __construct() {
        parent::__construct();
        $this->load->model('admin/Orders_model', 'adminorders_model');
        $this->load->model('admin/Products_model', 'adminProducts_model');
    }

    function zohoOrders() {
        $script_basePath = '/var/www/html/kptracking/pricecalc/application/';
        $log_FilePath = $script_basePath . 'logs/zoho_entries/';
        $sleep = 3600;
        while (true) {
            $log_FileName = $log_FilePath . 'kpin_order_dump_zoho_' . date('d-m-Y') . '.txt';
            $log_file_text = PHP_EOL . "[" . date("M d H:i:s") . "]\t info: Process started at " . date('d-m-Y H:i:s') . PHP_EOL;
            @file_put_contents($log_FileName, $log_file_text, FILE_APPEND);
            unset($log_file_text);
            $arrResultSet = NULL;
            $strQuery = "SELECT *, `shipping`.`name` AS `shipping_name`,`shipping`.`first_name` AS `shipping_first_name`, `shipping`.`last_name` AS `shipping_last_name`, `shipping`.`phone` AS `shipping_phone`,
                        `shipping`.`address1` AS `shipping_address1`,`shipping`.`city` AS `shipping_city`, `shipping`.`province` AS `shipping_province`,`shipping`.`country` AS `shipping_country`,`shipping`.`zip` AS `shipping_zip`,`shipping`.`address2` as `shipping_address2`, `product_details`.`id` AS `order_product_details_id`
                        FROM `kpin_order_details` AS  `order`
                        LEFT JOIN `kpin_order_product_details` AS `product_details` ON ( `product_details`.`order_id` =  `order`.`order_id` )
                        LEFT JOIN `kpin_billing_details` AS `billing` ON (`product_details`.`order_id` =  `billing`.`order_id`)
                        LEFT JOIN `kpin_shipping_details` AS `shipping` ON (`product_details`.`order_id` =  `shipping`.`order_id`)
                        WHERE ( `product_details`.`id` > 0 and ((`product_details`.`status` in ('success') or `product_details`.`status` is NUll) AND `product_details`.`zoho_id` is NULL)
                        or (`product_details`.`status` = 'cancelled' AND `product_details`.`zoho_id` is not NULL AND `product_details`.`id` > 0))";

            $arrResultSet = $this->db->query($strQuery);
//            echo "<pre>";print_r($arrResultSet->result());exit; 
            $Exchange_rate = 63;
            if (is_array($arrResultSet->result()) && count($arrResultSet->result()) > 0) {

                //Self-client grant code
                //$grant_code = "1000.ecae4299fa6681351eb0b9684e640510.db4ccbc6dee9c9b747059b911a0dcb65";
                $refresh_token = "1000.9d9d6cc032d2709765faac00c3ea23b1.f2b3be8a332b502ef7e3c3c36200601e";

                //Generate Refresh Token
                $step1_apiurl = 'https://accounts.zoho.com/oauth/v2/token';
                $step1_data_string = 'client_id=1000.AL9EW5RPXSR4YYP2N66S8A8MUTICTH&client_secret=e31e945be42008adf085157b72f5217cdc72560af9&grant_type=refresh_token&refresh_token=' . $refresh_token;
                $step1_header = array(
                    'Content-Type' => 'application/x-www-form-urlencoded',
                    'Content-Length: ' . strlen($step1_data_string)
                );
                $step1_request_method = 'POST';
                $step1_response = $this->sendUrl($step1_apiurl, $step1_data_string, $step1_header, $step1_request_method);
                $step1_response_arr = json_decode($step1_response, TRUE);
                $oauth_access_token = $step1_response_arr['access_token'];
                //End Generate Refresh token
                //print_r($step1_response_arr);exit;
                foreach ($arrResultSet->result() as $row) {
                    $prods_image = null;
                    $productid = $row->item_id;
                    $Product = $this->adminProducts_model->getProductById($productid, 'kpin_product_details');
                    $Product_res = $Product->result_array();

                    $prods_image = $Product_res['image'];
                    $order_product_details_id = $row->order_product_details_id;
                    $sale_status = ($row->status == 'cancelled') ? 'cancelled' : 'SALE MADE';
                    $customer_name = empty($row->name) ? $row->first_name . ' ' . $row->last_name : $row->name;
                    $Paid_by_Customer = ($row->product_price - $row->discount_allocations) * $row->product_quantity;
                    $DELIVERY = '';
                    $DELIVERY = $this->getProductsTags($row->product_product_id);

                    $info = array('CUSTOMER NAME' => $customer_name,
                        'EXPECTED DELIVERY' => $DELIVERY,
                        'SALE Source' => 'KarmaPlace.in', #
                        'Date Payment Received' => $row->created_at,
                        'KP MASTER SALES ORDER No.' => $row->order_id, #order_id|shopify_order_id . ' | ' . $row->shopify_order_id
                        'Phone Number' => $row->shipping_phone,
                        'Mode of Payment' => $row->gateway,
                        'Shipping Address' => $row->shipping_address1,
                        'Shipping City' => $row->shipping_city,
                        'Shipping State' => $row->shipping_province,
                        'Shipping Zip Code' => $row->shipping_zip,
                        'Country' => $row->shipping_country,
                        'Email' => $row->email,
                        'SALE Status' => $sale_status,
                        'ORDER Status' => 'Order info received', #$row->status, #$row->shipment_status
                        'Order NOTES' => NULL,
                        'Original URL' => $prods_image, #$row->referring_site,
                        'ITEM DESCRIPTION' => $row->product_name, #$row->product_title,
                        'QTY' => $row->product_quantity,
                        'KP Order No. for multiple' => NULL, #$row->shopify_order_id, #$row->order_id,
                        'SKU' => $row->product_sku,
                        'VENDOR NAME' => $row->product_vendor,
                        'Payment Ref. Number' => NULL,
                        'VENDOR Product SKU' => $row->product_sku,
                        'Procurement Price' => NULL,
                        'Amount Paid by Customer' => $Paid_by_Customer);
                    ;
                    //echo "info: <pre>",print_r($info),"</pre>";die;
                    $jsondata = $this->JSONfydata($info);
                    //echo $jsondata."<br><br>";
                    $jsondata_arr = json_decode($jsondata, TRUE);
                    //echo "<pre>";
                    //print_r($jsondata_arr);
                    //exit;

                    $zoho_id = '';
                    $zoho_id = trim($row->zoho_id);

                    $log_file_text = '[' . date("M d H:i:s") . "]\t info: = jsondata" . $jsondata . PHP_EOL;
                    @file_put_contents($log_FileName, $log_file_text, FILE_APPEND);
                    unset($log_file_text);

                    if (isset($row->zoho_id) && !empty($row->zoho_id)) {

                        //Update in Zoho CRM
                        $step2_apiurl = 'https://www.zohoapis.com/crm/v2/KP_SALES/' . $zoho_id;
                        $step2_data_string = $jsondata;
                        $step2_header = array(
                            'Content-Type: application/json',
                            'Content-Length: ' . strlen($step2_data_string),
                            sprintf('Authorization: Zoho-oauthtoken %s', $oauth_access_token)
                        );
                        $step2_request_method = 'PUT';
                        $step2_response = $this->sendUrl($step2_apiurl, $step2_data_string, $step2_header, $step2_request_method);

                        //2nd zoho API hit - Done for some fields not getting updated on 1st API hit.
                        //$step2_response = $this->sendUrl($step2_apiurl, $step2_data_string, $step2_header, $step2_request_method);

                        $step2_response_arr = json_decode($step2_response, TRUE);
                        //End Update in Zoho CRM
                    } else {

                        //Insert in Zoho CRM
                        //prepare jsondata
                        $jsondata_arr['trigger'][1] = "approval";
                        $jsondata_arr['trigger'][2] = "blueprint";
                        $jsondata = json_encode($jsondata_arr);

                        $step2_apiurl = 'https://www.zohoapis.com/crm/v2/KP_SALES';
                        $step2_data_string = $jsondata;
                        $step2_header = array(
                            'Content-Type: application/json',
                            'Content-Length: ' . strlen($step2_data_string),
                            sprintf('Authorization: Zoho-oauthtoken %s', $oauth_access_token)
                        );
                        $step2_request_method = 'POST';
                        $step2_response = $this->sendUrl($step2_apiurl, $step2_data_string, $step2_header, $step2_request_method);

                        $step2_response_arr = json_decode($step2_response, TRUE);
                        //End Insert in Zoho CRM
                    }

                    $log_file_text = '[' . date("M d H:i:s") . "]\t info: Zoho Response for order id " . $row->order_id . " = " . print_r($step2_response_arr, true) . PHP_EOL;
                    @file_put_contents($log_FileName, $log_file_text, FILE_APPEND);
                    unset($log_file_text);

                    if (isset($step2_response_arr) && !empty($step2_response_arr)) {
                        // As new zoho insert was being carried out, so inserting the details into xcart_zoho_response table
                        $zoho_response_status = $step2_response_arr['data'][0]['status'];
                        if (isset($zoho_response_status) && $zoho_response_status == 'success') {
                            $json_zoho_id = $step2_response_arr['data'][0]['details']['id'];
                            $zoho_message = $step2_response_arr['data'][0]['message'];
                            $where = array('id' => $order_product_details_id);
                            $product_details_data = array('zoho_id' => $json_zoho_id, 'zoho_message' => $zoho_message);
                            $log_file_text = '[' . date("M d H:i:s") . "]\t info: zoho_id :" . $json_zoho_id . ", details updated fail." . PHP_EOL;
                            if ($this->adminorders_model->update_data($where, $product_details_data, 'kpin_order_product_details')) {
                                $log_file_text = '[' . date("M d H:i:s") . "]\t info: zoho_id :" . $zoho_id . ", details got updated." . PHP_EOL;
                            }
                            @file_put_contents($log_FileName, $log_file_text, FILE_APPEND);
                            unset($log_file_text);
                        } else {
                            $json_zoho_id = $step2_response_arr['data'][0]['details']['id'];
                            $zoho_message = $step2_response_arr['data'][0]['code'] . ' | ' . $step2_response_arr['data'][0]['message'];
                            $where = array('id' => $order_product_details_id);
                            $product_details_data = array('zoho_id' => $json_zoho_id, 'zoho_message' => $zoho_message);

                            $log_file_text = '[' . date("M d H:i:s") . "]\t info:  kpin_order_product_details.id :" . $order_product_details_id . ", details updated fail." . PHP_EOL;
                            if ($this->adminorders_model->update_data($where, $product_details_data, 'kpin_order_product_details')) {
                                $log_file_text = '[' . date("M d H:i:s") . "]\t info: kpin_order_product_details.id :" . $order_product_details_id . ", details got updated." . PHP_EOL;
                            }
                            @file_put_contents($log_FileName, $log_file_text, FILE_APPEND);
                            unset($log_file_text);
                        }

                        $log_file_text = '[' . date("M d H:i:s") . "]\t info: Zoho Response for order id " . $row->order_id . " = " . print_r($step2_response_arr, true) . PHP_EOL;
                        @file_put_contents($log_FileName, $log_file_text, FILE_APPEND);
                        unset($log_file_text);
                    }
                    unset($step2_response_arr, $info, $customer_name, $order_product_details_id);
                }
            } else {
                $log_file_text = PHP_EOL . "[" . date("M d H:i:s") . "]\t info: No data" . PHP_EOL;
                $log_file_text .= PHP_EOL . "[" . date("M d H:i:s") . "]\t info: Waiting for $sleep minutes before moving to next loop " . date('d-m-Y H:i:s') . PHP_EOL;
                @file_put_contents($log_FileName, $log_file_text, FILE_APPEND);
                unset($log_file_text);
                sleep($sleep);
            }

            $log_file_text = PHP_EOL . "[" . date("M d H:i:s") . "]\t info: Waiting for $sleep minutes before moving to next loop" . PHP_EOL;
            @file_put_contents($log_FileName, $log_file_text, FILE_APPEND);
            unset($log_file_text);
            sleep($sleep);
        }
    }

    public function orderdump($orders) {
        //echo "<pre>";
        //print_r($orders);
        //exit;
        if (!is_array($orders)) {
            return false;
        }
        foreach ($orders as $order) {
            //if($order['name'] == '#IBSH8232' || $order['name'] == '#IBSH8233' || $order['name'] == '#IBSH8234' || $order['name'] == '#IBSH8235' || $order['name'] == '#IBSH8236') {
            if (isset($order['discount_applications']['0']['value']) && $order['discount_applications']['0']['value'] != '') {
                $discount_value = $order['discount_applications']['0']['value'];
            } else {
                $discount_value = 0;
            }

            if (isset($order['discount_applications']['0']['code']) && $order['discount_applications']['0']['code'] != '') {
                $discount_code = $order['discount_applications']['0']['code'];
            } else {
                $discount_code = '';
            }

            $orderId = str_replace("#", "", $order['name']);

            $array_orderid = array('order_id' => $orderId);
            $hasOrder = $this->adminorders_model->getOrderById($orderId, 'kpin_order_details');

            $dataShipping = array();
            $dataBilling = array();
            $dataShipping = array(
                'first_name' => $order['shipping_address']['first_name'],
                'address1' => $order['shipping_address']['address1'],
                'phone' => $order['shipping_address']['phone'],
                'city' => $order['shipping_address']['city'],
                'zip' => $order['shipping_address']['zip'],
                'province' => $order['shipping_address']['province'],
                'country' => $order['shipping_address']['country'],
                'last_name' => $order['shipping_address']['last_name'],
                'address2' => $order['shipping_address']['address2'],
                'company' => $order['shipping_address']['company'],
                'name' => $order['shipping_address']['name'],
                'country_code' => $order['shipping_address']['country_code'],
                'province_code' => $order['shipping_address']['province_code']
            );

            $dataBilling = array(
                'first_name' => $order['billing_address']['first_name'],
                'address1' => $order['billing_address']['address1'],
                'phone' => $order['billing_address']['phone'],
                'city' => $order['billing_address']['city'],
                'zip' => $order['billing_address']['zip'],
                'province' => $order['billing_address']['province'],
                'country' => $order['billing_address']['country'],
                'last_name' => $order['billing_address']['last_name'],
                'address2' => $order['billing_address']['address2'],
                'company' => $order['billing_address']['company'],
                'name' => $order['billing_address']['name'],
                'country_code' => $order['billing_address']['country_code'],
                'province_code' => $order['billing_address']['province_code']
            );

            if (!isset($order['billing_address']) && empty($order['billing_address'])) {
                $dataBilling = $dataShipping;
            }

            $vendors = '';
            foreach ($order['fulfillments'] as $fulfillment) {
                $status = $fulfillment['status'];
                $shipment_status = $fulfillment['shipment_status'];
            }
            foreach ($order['line_items'] as $product) {
                $product_id = NULL;
                $product_id = $product['product_id'];
                $variant_id = $product['variant_id'];

                if ($product['product_id'] == '') {
                    $data = $this->orderProductIdVarientIssue($product);
                    $product_id = $data['item_id_tobeupdated'];
                    $variant_id = $data['variant_id_tobeupdated'];
                }
                $where = array('product_id' => $product['id'], 'order_id' => $orderId);
                $dataProduct = array(
                    'product_id' => $product['id'],
                    'status' => $status,
                    'created_at' => $order['created_at'],
                    'shipment_status' => $shipment_status,
                    // 'service' =>  $product['gateway'],
                    'updated_at' => $order['updated_at'],
                    // 'tracking_company' =>  $product['subtotal-price'],
                    'shipment_status' => $product['total_weight'],
                    // 'location_id' =>  $product['total-tax'],
                    // 'tracking_number' =>  $product['taxes-included'],
                    // 'tracking_url' =>  $product['currency'],
                    // 'name' =>  $product['financial-status'],
                    'referring_site' => $order['referring_site'],
                    'item_id' => $product_id,
                    'product_variant_id' => $variant_id,
                    'product_title' => $product['title'],
                    'product_quantity' => $product['quantity'],
                    'product_price' => $product['price'],
                    'product_sku' => $product['sku'],
                    'product_variant_title' => $product['variant_title'],
                    'product_vendor' => $product['vendor'],
                    'product_fulfillment_service' => $product['fulfillment_service'],
                    'product_product_id' => $product_id,
                    'product_requires_shipping' => $product['requires_shipping'],
                    'product_taxable' => $product['taxable'],
                    'product_gift_card' => $product['gift_card'],
                    'product_name' => $product['name'],
                    'product_variant_inventory_management' => $product['variant_inventory_management'],
                    // 'product_properties' =>  $product['properties'],
                    'product_product_exists' => $product['product_exists'],
                    'product_fulfillable_quantity' => $product['fulfillable_quantity'],
                    'product_grams' => $product['grams'],
                    'product_total_discount' => $product['total_discount'],
                    'product_fulfillment_status' => $product['fulfillment_status'],
                    'product_price_set_amount' => $product['price_set']['shop_money']['amount'],
                    'product_price_set_currency_code' => $product['price_set']['shop_money']['currency_code'],
                    'product_total_discount_set_amount' => $product['total_discount_set']['shop_money']['amount'],
                    'product_total_discount_set_currency_code' => $product['total_discount_set']['shop_money']['currency_code'],
                    'discount_allocations' => $product['discount_allocations'][0]['amount']
                        // 'product_tax_lines_title' =>  $product['subtotal-price'],
                        // 'product_tax_lines_price' =>  $product['total-weight'],
                        // 'product_tax_lines_rate' =>  $product['total-tax'],
                        // 'product_tax_lines_currency_code' =>  $product['taxes-included'],
                );
                #$vendors .= $product['vendor'] . ',';
                if ($hasOrder->num_rows() >= 1) {
                    $this->adminorders_model->update_data($where, $dataProduct, 'kpin_order_product_details');
                    echo PHP_EOL . $this->db->last_query() . PHP_EOL;
                } else {
                    $dataProduct = array_merge($dataProduct, $array_orderid);
                    $this->db->insert('kpin_order_product_details', $dataProduct);
                }
            }

            #$vendorsFinal = rtrim($vendors, ",");

            $dataOrder = array(
                'email' => $order['email'],
                'shopify_order_id' => $order['id'],
                'customer_id' => $order['customer']['id'],
                'created_at' => $order['created_at'],
                'updated_at' => $order['updated_at'],
                'gateway' => $order['gateway'],
                #'vendors' => $vendorsFinal,
                'total_price' => $order['total_price'],
                'subtotal_price' => $order['subtotal_price'],
                'total_weight' => $order['total_weight'],
                'total_tax' => $order['total_tax'],
                'taxes_included' => $order['taxes_included'],
                'currency' => $order['currency'],
                'financial_status' => $order['financial_status'],
                'confirmed' => $order['confirmed'],
                'total_discounts' => $order['total_discounts'],
                'total_line_items_price' => $order['total_line_items_price'],
                'cart_token' => $order['cart_token'],
                'buyer_accepts_marketing' => $order['buyer_accepts_marketing'],
                'name' => $order['name'],
                'cancelled_at' => $order['cancelled_at'],
                'total_price_usd' => $order['total_price_usd'],
                'checkout_token' => $order['checkout_token'],
                'processed_at' => $order['processed_at'],
                'order_number' => $order['order_number'],
                'discount_value' => $discount_value,
                'discount_code' => $discount_code,
                'payment_gateway_name' => $order['payment_gateway_name'],
                'processing_method' => $order['processing_method'],
                'checkout_id' => $order['checkout_id'],
                'fulfillment_status' => $order['fulfillment_status'],
                'rate' => $order['rate'],
                'tax_title' => $order['title'],
                'contact_email' => $order['contact_email'],
                'total_shipping' => $order['total_shipping_price_set']['shop_money']['amount']
            );

            if ($hasOrder->num_rows() >= 1) {
                $this->adminorders_model->update_data($array_orderid, $dataBilling, 'kpin_billing_details');
                $this->adminorders_model->update_data($array_orderid, $dataShipping, 'kpin_shipping_details');
                $this->adminorders_model->update_data($array_orderid, $dataOrder, 'kpin_order_details');
            } else {
                $dataBilling = array_merge($dataBilling, $array_orderid);
                $dataShipping = array_merge($dataShipping, $array_orderid);
                $dataOrder = array_merge($dataOrder, $array_orderid);

                $query_bill = $this->db->get_where('kpin_billing_details', array('order_id' => $orderId))->result_array();
                if (count($query_bill) == 0) {
                    $this->db->insert('kpin_billing_details', $dataBilling);
                }

                $query_ship = $this->db->get_where('kpin_shipping_details', array('order_id' => $orderId))->result_array();
                if (count($query_ship) == 0) {
                    $this->db->insert('kpin_shipping_details', $dataShipping);
                }
                //print_r($query_ship);
                //exit;

                $this->db->insert('kpin_order_details', $dataOrder);
            }
            unset($product, $dataBilling, $dataShipping, $dataOrder, $orderId, $vendors, $array_orderid, $hasOrder);
            //}
        }
    }

    public function getOrders($filters = array()) {
        $minutes_to_sub = 1440; #21600;
        //$minutes_to_sub = 15760; #21600;
        $datetime = new DateTime();
        $toDate = $datetime->format('c');
        $datetime->sub(new DateInterval("PT" . $minutes_to_sub . "M"));
        $fromDate = $datetime->format('c');

        $session = curl_init();
        $headers = array();
        $headers[] = 'content-type: application/json';

        //for ($i= 1; $i < 10000; $i++) {
        //$filter = array('limit' => 250, 'page' => $i,'created_at_min' => $fromDate,'status' => 'any');
        $filter = array('limit' => 250, 'created_at_min' => $fromDate, 'status' => 'any');

        $param = http_build_query($filter);

        $url = "https://" . "{$this->_kpin_apiKey}:{$this->_kpin_secret}@{$this->_kpin_storeURL}" . "/admin/api/2020-10/orders.json" . '?' . $param;
        curl_setopt($session, CURLOPT_URL, $url);
        curl_setopt($session, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($session, CURLOPT_TIMEOUT, 20);
        curl_setopt($session, CURLOPT_CONNECTTIMEOUT, 20);
        curl_setopt($session, CURLOPT_HTTPHEADER, $headers);

        $responseOrders = curl_exec($session);
        $orders = json_decode($responseOrders, true);
//        echo "<pre>";
//        print_r($orders);
//        die; 

        /* $this->xml = curl_exec($session);
          $xml = $this->_getDOM($this->xml);
          #echo $xml;
          $result = null;
          $result = $this->_xpath($xml, "/orders/order");
          #$result->nodeset.PHP_EOL;
          $orders = array();
          if (isset($result->nodeset)) {
          foreach ($result->nodeset as $orderNode) {
          $orders[] = $this->_xmlToArray($orderNode);
          }
          } else {
          foreach ($result as $orderNode) {
          $orders[] = $this->_xmlToArray($orderNode);
          }
          } */
        #return $orders;
        #print_r($orders);
        $orders = $orders['orders'];
        if (is_array($orders) && count($orders) > 0) {
            if (!$this->orderdump($orders)) {
                echo PHP_EOL . 'array empty => no more orders' . PHP_EOL;
            }
        } else {
            return false;
        }
        sleep(1);
        //}
        curl_close($session);
    }

    public function productdump($getProducts = array()) {
        #$getProducts = $this->getProducts();
        if (!is_array($getProducts)) {
            return false;
        }

        foreach ($getProducts['products'] as $product) {
            $productId = $product['id'];
            $array_productid = array('product_id' => $productId);
            $table = 'kpin_product_details';
            $varientTable = 'kpin_variants_details';
            $hasProduct = $this->adminProducts_model->getProductById($productId, $table);
            #echo PHP_EOL.$this->db->last_query().PHP_EOL;exit;
            $dataProduct = array();
            $dataProduct = array(
                'product_id' => $productId,
                'body_html' => $product['body_html'],
                'created_at' => $product['created_at'],
                'vendor' => $product['vendor'],
                'updated_at' => $product['updated_at'],
                'product_type' => $product['product_type'],
                'handle' => $product['handle'],
                'tags' => $product['tags'],
                'published_at' => $product['published_at'],
                'product_title' => $product['title'],
                'image' => $product['image']['src'],
            );

            if ($hasProduct->num_rows() >= 1) {
                echo PHP_EOL . ' in update product ' . $productId . PHP_EOL;
                $this->adminorders_model->update_data($array_productid, $dataProduct, 'kpin_product_details');
            } else {
                echo PHP_EOL . ' in INSERT product ' . $productId . PHP_EOL;
                $dataProduct = array_merge($dataProduct, $array_productid);
                $this->db->insert('kpin_product_details', $dataProduct);
            }
            $dataVariant = array();
            foreach ($product['variants'] as $variant) {
                $dataVariant = array(
                    'variant_id' => $variant['id'],
                    'product_id' => $variant['product_id'],
                    'title' => $variant['title'],
                    'price' => $variant['price'],
                    'sku' => $variant['sku'],
                    'position' => $variant['position'],
                    'inventory_policy' => $variant['inventory_policy'],
                    'compare_at_price' => $variant['compare_at_price'],
                    'fulfillment_service' => $variant['fulfillment_service'],
                    'inventory_management' => $variant['inventory_management'],
                    'option1' => $variant['option1'],
                    'option2' => $variant['option2'],
                    'option3' => $variant['option3'],
                    'created_at' => $variant['created_at'],
                    'updated_at' => $variant['updated_at'],
                    'taxable' => $variant['taxable'],
                    'barcode' => $variant['barcode'],
                    'grams' => $variant['grams'],
                    'weight' => $variant['weight'],
                    'weight_unit' => $variant['weight_unit'],
                    'inventory_item_id' => $variant['inventory_item_id'],
                    'inventory_quantity' => $variant['inventory_quantity'],
                    'old_inventory_quantity' => $variant['old_inventory_quantity'],
                    'requires_shipping' => $variant['requires_shipping']
                );

                $dataProduct = array_merge($dataVariant, $array_productid);
                if ($hasProduct->num_rows() >= 1) {
                    $variantId = $variant['id'];
                    $hasVarient = $this->adminProducts_model->getProductByVarientId($productId, $variantId, $varientTable);
                    if ($hasVarient->num_rows() >= 1) {
                        $this->adminorders_model->update_data(array('product_id' => $productId, 'variant_id' => $variantId), $dataVariant, $varientTable);
                    } else {
                        $this->db->insert($varientTable, $dataVariant);
                    }
                } else {
                    $this->db->insert($varientTable, $dataVariant);
                }
            }
        }
    }

    public function getProductsOld()/* $products_id = array() */ {
        $session = curl_init();
        $headers = array();
        $headers[] = 'content-type: application/XML';
        $is_specific = false;

        $minutes_to_sub = 1440; #216000=150days;
        $datetime = new DateTime();
        $toDate = $datetime->format('c');
        $datetime->sub(new DateInterval("PT" . $minutes_to_sub . "M"));
        #updated_at_min = Show products last updated after date. (format: 2014-04-25T16:15:47-04:00)
        $updated_at_min = $datetime->format('c'); // product updated after date 
        //for ($i= 572; $i < 10000; $i++) {
        $filter = array('limit' => 250, 'updated_at_min' => $updated_at_min); /* , 'published_status' => 'published' */
        //$filter = array('limit' => 250, 'title' => "Women's Viscose Rayon Anarkali Kurta in Teal Green");/*, 'published_status' => 'published'*/
        // $filter = array('limit' => 250, 'page' => $i,'updated_at_min' => $updated_at_min);/*, 'published_status' => 'published'*/
        $param = http_build_query($filter);
        $url = "https://" . "{$this->_kpin_apiKey}:{$this->_kpin_secret}@{$this->_kpin_storeURL}" . "/admin/api/2020-10/products.json" . '?' . $param;
        echo PHP_EOL . $url . PHP_EOL;
        curl_setopt($session, CURLOPT_URL, $url);
        curl_setopt($session, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($session, CURLOPT_TIMEOUT, 20);
        curl_setopt($session, CURLOPT_CONNECTTIMEOUT, 20);
        curl_setopt($session, CURLOPT_HTTPHEADER, $headers);

        $res = curl_exec($session);
        $products = json_decode($res, true);

        //echo "<pre>";
        //print_r($products);
        //die;
        if (is_array($products) && count($products) > 0) {
            if (!$this->productdump($products)) {
                echo PHP_EOL . 'array empty => no more product' . PHP_EOL;
                sleep(5);
            }
        } else {
            exit;
        }
        //}
        curl_close($session);
    }

    public function getProducts()/* $products_id = array() */ {
        $minutes_to_sub = 720; // 300 days   2880 = 2
        $datetime = new DateTime();
        $toDate = $datetime->format('c');
        $datetime->sub(new DateInterval("PT" . $minutes_to_sub . "M"));
        $fromDate = $datetime->format('c');
        #$filter = array('limit' => 250, 'page' => $i);/*, 'published_status' => 'published'*/
        //$filter = array('limit' => 250, 'page' => $i, 'updated_at_min' => $fromDate, 'status' => 'any');
        #$filter = array('limit' => 250, 'page' => $i, 'status' => 'any', 'vendor' => 'Imli Street');
        $filter = array('limit' => 250, 'updated_at_min' => $fromDate);
        $param = http_build_query($filter);
        $url = "https://" . "{$this->_kpin_apiKey}:{$this->_kpin_secret}@{$this->_kpin_storeURL}" . "/admin/api/2020-10/products.json" . '?' . $param;
        $this->curlRequest($url);
    }

    public function curlRequest($url) {
        $session = curl_init();
        curl_setopt($session, CURLOPT_URL, $url);
        curl_setopt($session, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($session, CURLOPT_TIMEOUT, 20);
        curl_setopt($session, CURLOPT_CONNECTTIMEOUT, 20);
        curl_setopt($session, CURLOPT_VERBOSE, 1);
        curl_setopt($session, CURLOPT_HEADER, 1);
        $res = curl_exec($session);

        // Then, after your curl_exec call:
        $header_size = curl_getinfo($session, CURLINFO_HEADER_SIZE);
        $header = substr($res, 0, $header_size);
        $body = substr($res, $header_size);
        $products = json_decode($body, true);
//        echo "<pre>";print_r($products);echo "</pre>"; die;
        echo PHP_EOL . '<br> Products count :' . count($products['products']);
        if (is_array($products['products']) && count($products['products']) > 0) {
            $logFilePath = $_SERVER['DOCUMENT_ROOT'] . "assets/logs/kpin/products/" . date('Y') . "/" . date('M');
            if (!is_dir($logFilePath)) {
                mkdir($logFilePath, 0777, true);
            }
//            $fp = fopen($logFilePath . "/products-" . date("Y-M-d") . ".txt", "a");
//            fwrite($fp, json_encode($products) . "<br>" . "\r\n");
//            fclose($fp);
            $this->productdump($products);
            if (preg_match('/<(.*)>; rel="previous"/', $header)) {
                $previous = explode('rel="previous",', $header);
                $header = $previous[1];
            }
            preg_match('/<(.*)>; rel="next"/', $header, $matches);
            //echo "<pre>",print_r($matches),"</pre>";
            if (count($matches) > 1) {
                $url = str_replace("https://", "https://" . "{$this->_kpin_apiKey}:{$this->_kpin_secret}@", $matches[1]);
                $res = $this->curlRequest($url);
            }
        } else {
            echo PHP_EOL . '<br> array empty => no more product' . PHP_EOL;
            exit;
        }
        curl_close($session);
    }

    public function _getDOM($xmlDoc) {
        if (function_exists("domxml_open_mem"))
            return domxml_open_mem($xmlDoc);
        else if (method_exists("DOMDocument", "loadXML"))
            return DOMDocument::loadXML($xmlDoc);
        else
            return null;
    }

    public function _xpath($dom, $query) {
        if (method_exists($dom, "xpath_new_context")) {
            $xpath = $dom->xpath_new_context();
            return $xpath->xpath_eval("/orders/order");
        } else if (class_exists("DOMXPath")) {
            $xpath = new DOMXPath($dom);
            return $xpath->query($query);
        } else {
            return null;
        }
    }

    public function _xmlToArray($xmlNode) {
        $result = array();
        if (method_exists($xmlNode, "child_nodes")) {
            foreach ($xmlNode->child_nodes() as $childNode) {
                if ($childNode->node_name() == '#text')
                    ; //Do nothing
                else if (count($childNode->child_nodes()) < 2)
                    $result[$childNode->node_name()] = $childNode->get_content();
                else
                    $xmlNode->get_attribute('type') == "array" ?
                                    $result[] = $this->_xmlToArray($childNode) :
                                    $result[$childNode->node_name()] = $this->_xmlToArray($childNode);
            }
        } else if (isset($xmlNode->nodeName)) {
            foreach ($xmlNode->childNodes as $childNode) {
                if ($childNode->nodeName == '#text')
                    ; //Do nothing
                else if ($childNode->childNodes->length < 2)
                    $result[$childNode->nodeName] = $childNode->nodeValue;
                else
                    $xmlNode->getAttribute('type') == "array" ?
                                    $result[] = $this->_xmlToArray($childNode) :
                                    $result[$childNode->nodeName] = $this->_xmlToArray($childNode);
            }
        }
        return $result;
    }

    function sendUrl($url, $data = null, $header, $request_method) {
        $ch = curl_init();
        $timeout = 5;

        if ($data) {
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
            curl_setopt($ch, CURLOPT_VERBOSE, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        }
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $request_method);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, $timeout);
        $data = curl_exec($ch);
        curl_close($ch);

        return $data;
    }

    function JSONfydata($arr) {
        $json_arr = array();
        foreach ($arr as $key => $val) {
            //Set API Names
            $key = trim($key);
            if ($key == 'Actual Shipping Charges (USD)') {
                $key = 'Actual_Shipping_Charges_USD';
            } else if ($key == 'All Notes') {
                $key = 'All_Notes';
            } else if ($key == 'Amount Paid by Customer' || $key == 'price') {
                $key = 'Amount_Paid_by_Customer';
                $val = (string) $val;
            } else if ($key == 'Amount Paid for Shipping') {
                $key = 'Amount_Paid_for_Shipping';
            } else if ($key == 'Amount Refund Received from Vendor Rs.') {
                $key = 'Amount_Refund_Received_from_Vendor_Rs';
            } else if ($key == 'COLOR / DESIGN') {
                $key = 'COLOR_DESIGN';
            } else if ($key == 'Country') {
                $key = 'Country';
            } else if ($key == 'COURIER NAME') {
                $key = 'Shipped_using';
            } else if ($key == 'Created By') {
                $key = 'Created_By';
            } else if ($key == 'CUSTOMER NAME') {
                $key = 'CUSTOMER_NAME';
            } else if ($key == 'Date Dispatched to customer') {
                $key = 'Date_11';
                $val = date('Y-m-d', strtotime($val));
            } else if ($key == 'Date Item arrived  in Mum') {
                $key = 'Date_13';
                $val = date('Y-m-d', strtotime($val));
            } else if ($key == 'Date of Pocessing payments to Accounts') {
                $key = 'Date_of_Pocessing_payments_to_Accounts';
                $val = date('c', strtotime($val));
            } else if ($key == 'Date of Procurement') {
                $key = 'Date_of_Procurement';
                $val = date('Y-m-d', strtotime($val));
            } else if ($key == 'Date Payment Received') {
                $key = 'Date_Payment_Received';
                $val = date('Y-m-d', strtotime($val));
            } else if ($key == 'Date Procured from 3rd party') {
                $key = 'Date_Procured_from_3rd_party';
                $val = date('Y-m-d', strtotime($val));
            } else if ($key == 'Date QA') {
                $key = 'Date_15';
                $val = date('Y-m-d', strtotime($val));
            } else if ($key == 'DATE received by KP') {
                $key = 'DATE_received_by_Vendor';
                $val = date('Y-m-d', strtotime($val));
            } else if ($key == 'Date Refunded') {
                $key = 'Date_Refunded';
                $val = date('Y-m-d', strtotime($val));
            } else if ($key == 'Date Return Request') {
                $key = 'Date_Return_Request';
                $val = date('Y-m-d', strtotime($val));
            } else if ($key == 'Date Shipped by Vendor') {
                $key = 'Date_Shipped_by_Vendor';
                $val = date('Y-m-d', strtotime($val));
            } else if ($key == 'DATE shipped to customer') {
                $key = 'DATE_shipped_to_customer';
                $val = date('Y-m-d', strtotime($val));
            } else if ($key == 'Date Vendor Confirmed Order') {
                $key = 'Date_12';
                $val = date('Y-m-d', strtotime($val));
            } else if ($key == 'Date Vendor PO Sent') {
                $key = 'Date_Vendor_PO_Sent';
                $val = date('Y-m-d', strtotime($val));
            } else if ($key == 'DISPATCHED BY') {
                $key = 'DISPATCHED_BY';
            } else if ($key == 'Email') {
                $key = 'Email';
            } else if ($key == 'Exchange / Credit Certificate No.') {
                $key = 'Exchange_Credit_Certificate_No';
            } else if ($key == 'Exchange Credit Amount') {
                $key = 'Exchange_Credit_Amount';
            } else if ($key == 'EXPECTED DELIVERY') {
                $key = 'EXPECTED_DELIVERY';
            } else if ($key == 'If Canceled / Return Amount due from Vendor') {
                $key = 'If_Canceled_Return_AMount_due_from_Vendor';
            } else if ($key == 'Inspected and Shipped') {
                $key = 'Inspected_and_Shipped';
                $val = filter_var($val, FILTER_VALIDATE_BOOLEAN);
            } else if ($key == 'Inspected By') {
                $key = 'Inspected_By';
            } else if ($key == 'INV BAR CODE') {
                $key = 'INV_BAR_CODE';
                $val = (string) $val;
            } else if ($key == 'Item arrived in warehouse') {
                $key = 'Item_arrived_in_warehouse';
                $val = filter_var($val, FILTER_VALIDATE_BOOLEAN);
            } else if ($key == 'ITEM DESCRIPTION' || $key == 'product_name') {
                $key = 'ITEM_DESCRIPTION';
            } else if ($key == 'Item purchased with 3rd-party -') {
                $key = 'Item_purchased_with_3rd_party';
                $val = filter_var($val, FILTER_VALIDATE_BOOLEAN);
            } else if ($key == 'KP MASTER SALES ORDER No.') {
                $key = 'Name';
            } else if ($key == 'KP Order No. for multiple') {
                $key = 'Master_Order_no_for_multiple';
            } else if ($key == 'KP SALES Owner') {
                $key = 'Owner';
            } else if ($key == 'KP Unique Order Ref No.') {
                $key = 'KP_REFERENCE_No';
            } else if ($key == 'Mode of Payment') {
                $key = 'Mode_of_Payment';
            } else if ($key == 'Modified By') {
                $key = 'Modified_By';
            } else if ($key == 'NOTES') {
                $key = 'NOTES1';
            } else if ($key == 'NOTES ON SHIPPING') {
                $key = 'NOTES_ON_SHIPPING';
            } else if ($key == 'Order NOTES') {
                $key = 'Order_NOTES';
            } else if ($key == 'ORDER Status') {
                $key = 'ORDER_Status';
            } else if ($key == 'Original URL') {
                $key = 'Original_URL';
            } else if ($key == 'Payment Ref. Number') {
                $key = 'Payment_Ref_Number';
            } else if ($key == 'Payment Type') {
                $key = 'Payment_Type';
            } else if ($key == 'Phone Number') {
                $key = 'Phone_Number';
            } else if ($key == 'Procurement Price') {
                $key = 'Procurement_Price';
            } else if ($key == 'Procurement Status') {
                $key = 'Procurement_Status';
            } else if ($key == 'PRODUCT FINISHING') {
                $key = 'PRODUCT_FINISHING';
            } else if ($key == 'QA CHECK PASS/FAIL') {
                $key = 'QA_CHECK_PASS_FAIL';
            } else if ($key == 'QA Failed') {
                $key = 'QA_Failed';
                $val = filter_var($val, FILTER_VALIDATE_BOOLEAN);
            } else if ($key == 'QA NOTES') {
                $key = 'QA_NOTES';
            } else if ($key == 'QA Passed') {
                $key = 'QA_Passed';
                $val = filter_var($val, FILTER_VALIDATE_BOOLEAN);
            } else if ($key == 'QTY') {
                $key = 'QTY';
            } else if ($key == 'QUANTITY matches order') {
                $key = 'QUANTITY_matches_order';
            } else if ($key == 'Recommended size Letter') {
                $key = 'Recommended_size_Letter';
            } else if ($key == 'Recommended size No.') {
                $key = 'Recommended_size_No';
            } else if ($key == 'Refund Amount') {
                $key = 'Refund_Amount';
            } else if ($key == 'REFUND REASON') {
                $key = 'REFUND_REASON';
            } else if ($key == 'REFUND TYPE') {
                $key = 'REFUND_TYPE';
            } else if ($key == 'Return or Exchange') {
                $key = 'Return_or_Exchange';
            } else if ($key == 'Return Shipping Cost') {
                $key = 'Return_Shipping_Cost';
            } else if ($key == 'Return Shipping tracking number') {
                $key = 'Return_Shipping_tracking_number';
            } else if ($key == 'RMA Number if applicable') {
                $key = 'RMA_Number';
            } else if ($key == 'SALE Source') {
                $key = 'SALE_Source';
            } else if ($key == 'SALE Status') {
                $key = 'SALE_Status';
            } else if ($key == 'SHIPMENT TRACKING No.') {
                $key = 'SHIPEMENT_TRACKING_No';
                $val = trim($val, "'");
            } else if ($key == 'Shipping Address') {
                $key = 'Shipping_Address';
            } else if ($key == 'Shipping BAR CODE') {
                $key = 'ICC_BAR_CODE';
            } else if ($key == 'Shipping City') {
                $key = 'Shipping_City';
            } else if ($key == 'SHipping cost to be deducted from Refund') {
                $key = 'SHipping_cost_to_be_deducted_from_Refund';
            } else if ($key == 'Shipping State') {
                $key = 'Shipping_State';
            } else if ($key == 'Shipping Weight chrged by courier (DHL, ICC, Fedex') {
                $key = 'Shipping_Weight_chrged_by_courier_DHL_ICC_Fedex';
            } else if ($key == 'Shipping Weight lbs recorded by KP') {
                $key = 'Shipping_Weight_lbs';
            } else if ($key == 'Shipping Zip Code') {
                $key = 'Shipping_Zip_Code';
            } else if ($key == 'SIZE  ORDERED') {
                $key = 'SIZE';
            } else if ($key == 'Size Chart measurement checked') {
                $key = 'MEASUREMENTS_MATCH_SIZE';
            } else if ($key == 'SIZE NEEDED FOR EXCHANGE') {
                $key = 'SIZE_NEEDED_FOR_EXCHANGE';
            } else if ($key == 'SKU') {
                $key = 'SKU';
                $val = (string) $val;
            } else if ($key == 'STYLE & COLOR MATCH WEBSITE LISTING') {
                $key = 'Item_matches_Website_image_Description';
            } else if ($key == 'Vendor Confirmed Fulfillment') {
                $key = 'Vendor_Confirmed_Fulfillment';
                $val = filter_var($val, FILTER_VALIDATE_BOOLEAN);
            } else if ($key == 'VENDOR Email') {
                $key = 'VENDOR_Email';
            } else if ($key == 'VENDOR NAME' || $key == 'product_vendor') {
                $key = 'VENDOR_NAME';
            } else if ($key == 'VENDOR NOTES') {
                $key = 'VENDOR_NOTES';
            } else if ($key == 'VENDOR P.O. Number if different') {
                $key = 'VENDOR_P_O_Number';
            } else if ($key == 'Vendor P.O. Sent') {
                $key = 'Vendor_P_O_Sent';
                $val = filter_var($val, FILTER_VALIDATE_BOOLEAN);
            } else if ($key == 'Vendor Payment Date') {
                $key = 'Vendor_Payment_Date';
                $val = date('Y-m-d', strtotime($val));
            } else if ($key == 'Vendor Payment Status') {
                $key = 'Vendor_Payment_Status';
            } else if ($key == 'VENDOR Product SKU') {
                $key = 'VENDOR_Product_SKU';
            } else if ($key == 'Vendor refund to KP mode') {
                $key = 'Vendor_refund_to_KP_mode';
            } else if ($key == 'Vendor sent Tracking Number') {
                $key = 'Vendor_sent_Tracking_Number';
                $val = filter_var($val, FILTER_VALIDATE_BOOLEAN);
            } else if ($key == 'Vendor Tax invoice received?') {
                $key = 'Vendor_Tax_invoice_received';
                $val = filter_var($val, FILTER_VALIDATE_BOOLEAN);
            } else if ($key == 'VENDOR Tracking number') {
                $key = 'VENDOR_Tracking_number';
            }
            $json_arr["data"][0][$key] = $val;
            $json_arr["trigger"] = array("workflow");
        }
        $json = json_encode($json_arr);
        return $json;
    }

    public function orderProductIdVarientIssue($product) {
        $sku = $product['sku'];
        $title = $product['title'];

        //get product details
        $session1 = curl_init();
        $headers = array();
        $headers[] = 'content-type: application/x-www-form-urlencoded';
        $filter = array('limit' => 100, 'title' => $title);
        $param = http_build_query($filter);

        $url = "https://" . "{$this->_kpin_apiKey}:{$this->_kpin_secret}@{$this->_kpin_storeURL}" . "/admin/api/2020-10/products.json" . '?' . $param;
        curl_setopt($session1, CURLOPT_URL, $url);
        curl_setopt($session1, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($session1, CURLOPT_TIMEOUT, 20);
        curl_setopt($session1, CURLOPT_CONNECTTIMEOUT, 20);
        curl_setopt($session1, CURLOPT_HTTPHEADER, $headers);

        $responseProduct = curl_exec($session1);
        $products = json_decode($responseProduct, true);
        $products = $products['products'];
        //echo "Products: <pre>";
        //print_r($products);
        //die;
        //compare sku
        $variant_found = 0;
        $data = array();
        foreach ($products as $product) {
            $variant_arr = $product['variants'];
            foreach ($variant_arr as $variant) {
                if ($sku === $variant['sku']) {
                    $data['variant_id_tobeupdated'] = $variant['id'];
                    $data['item_id_tobeupdated'] = $variant['product_id'];
                    $variant_found = 1;
                    break;
                }
            }
            if ($variant_found == 1) {
                break;
            }
        }
        return $data;
    }

    public function getProductsTags($product_product_id) {
        $defalut = 'Delivered in 10 to 18 days';
        $search_tag = array('mandirs' => 'Delivered in 14 to 28 days', 'sarees' => 'Delivered in 10 to 18 days', 'lehengas' => 'Delivered in 10 to 18 days', 'custom-stitched' => 'Delivered in 10 to 18 days', 'delivery-time-10-12-days' => 'Delivered in 10 to 12 days', 'delivery-time-15-17-days' => 'Delivered in 15 to 17 days', 'delivery-time-18-20-days' => 'Delivered in 18 to 20 days', 'delivery-time-20-22-days' => 'Delivered in 20 to 22 days', 'delivery-time-22-25-days' => 'Delivered in 22 to 25 days', 'delivery-time-25-days-and-above' => 'Delivered in 25 to 45 days', 'delivery-time-4-5-days' => 'Delivered in 4 to 5 days');

        $this->db->select('tags');
        $this->db->from('kpin_product_details');
        $this->db->where('product_id', $product_product_id);
        $result = $this->db->get();
        $data = $result->result_array();
        $ogi_tags = strtolower($data[0]['tags']);
        $tags = preg_replace('/\s+/', '', $ogi_tags); /**/
        $tag_arr = explode(',', $tags);
        foreach ($tag_arr as $value) {
            if (array_key_exists($value, $search_tag)) {
                $defalut = $search_tag[$value];
                break;
            }
        }
        return $defalut;
    }
    
    public function getMissingProducts($product) {
//        $title = "Boy's Dupion Art Silk Nehru Jacket in Royal Blue";

        //get product details
        $session1 = curl_init();
        $headers = array();
        $headers[] = 'content-type: application/x-www-form-urlencoded';
//        $filter = array('limit' => 100, 'title' => $title);
        $filter = array('since_id' => 5383557316768, 'limit' => 250);
//        $filter = array('id' => 5383557316769, 'limit' => 100);
        $param = http_build_query($filter);
        $url = "https://" . "{$this->_kpin_apiKey}:{$this->_kpin_secret}@{$this->_kpin_storeURL}" . "/admin/api/2020-10/products.json" . '?' . $param;
        curl_setopt($session1, CURLOPT_URL, $url);
        curl_setopt($session1, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($session1, CURLOPT_TIMEOUT, 20);
        curl_setopt($session1, CURLOPT_CONNECTTIMEOUT, 20);
        curl_setopt($session1, CURLOPT_HTTPHEADER, $headers);

        $responseProduct =  curl_exec($session1);
        $products = json_decode($responseProduct, true);
        echo "<pre>";
        print_r($products);
        die;

        echo PHP_EOL . '<br> Products count :' . count($products['products']);
        if (is_array($products['products']) && count($products['products']) > 0) {
            $this->productdump($products);
            #if(!$this->productdump($products)){ echo PHP_EOL.'array empty => no1 more product'.PHP_EOL; exit;}
        } else {
            echo PHP_EOL . '<br> array empty => no more product' . PHP_EOL;
            exit;
        }
    }

}
