<?php
defined('BASEPATH') OR exit('No direct script access allowed');
error_reporting(0);

class Dashboard extends Admin_Controller {

    public function __construct()
    {
        parent::__construct();

        /* Load :: Common */
        $this->load->helper('number');
        $this->load->model('admin/dashboard_model');
    }


	public function index()
	{
        if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
        {
            redirect('auth/login', 'refresh');
        }
        else
        {
            /* Title Page */
            $this->page_title->push(lang('menu_dashboard'));
            $this->data['pagetitle'] = $this->page_title->show();

            /* Breadcrumbs */
            $this->data['breadcrumb'] = $this->breadcrumbs->show();

            /* Data */
            $this->data['count_users']       = $this->dashboard_model->get_count_record('usersLogin');
            $this->data['count_vendors']     = $this->dashboard_model->get_count_record('vendorDetails');
            $this->data['count_sku_price_details']     = $this->dashboard_model->get_count_record('sku_price_details');
            $this->data['vendorRegistration']     = $this->dashboard_model->get_count_record('vendorRegistration');
            $this->data['count_products']       = $this->dashboard_model->get_count_record('kp_product_details');

            $this->data['kporderscnt']  	   	= $this->dashboard_model->totalKpOrders('kp_order_details');
            $this->data['kporderscntPaid']  	= $this->dashboard_model->totalKpPaidOrders('kp_order_details');
            $this->data['kporderscntPRef']  	= $this->dashboard_model->totalKpPRefundedOrders('kp_order_details');
            $this->data['kporderscntRef']  	   	= $this->dashboard_model->totalKpRefundedOrders('kp_order_details');
            $this->data['kpordersGraph']  	   	= $this->dashboard_model->graphKPMonthlyOrders('kp_order_details');
            $this->data['kpvordersGraph']  	   	= $this->dashboard_model->graphKPVendorOrders('kp_order_details');
             
            $this->data['iborderscnt']  	   	= $this->dashboard_model->totalIBOrders('ibhejo_order_details');
            $this->data['iborderscntPaid']  	= $this->dashboard_model->totalIBPaidOrders('ibhejo_order_details');
            $this->data['iborderscntPRef']  	= $this->dashboard_model->totalIBPRefundedOrders('ibhejo_order_details');
            $this->data['iborderscntRef']  	   	= $this->dashboard_model->totalIBRefundedOrders('ibhejo_order_details');
            $this->data['ibordersGraph']  	   	= $this->dashboard_model->graphIBMonthlyOrders('ibhejo_order_details');
            
           
            
            // $this->data['disk_totalspace']   = $this->dashboard_model->disk_totalspace(DIRECTORY_SEPARATOR);
            // $this->data['disk_freespace']    = $this->dashboard_model->disk_freespace(DIRECTORY_SEPARATOR);
            // $this->data['disk_usespace']     = $this->data['disk_totalspace'] - $this->data['disk_freespace'];
            // $this->data['disk_usepercent']   = $this->dashboard_model->disk_usepercent(DIRECTORY_SEPARATOR, FALSE);
            // $this->data['memory_usage']      = $this->dashboard_model->memory_usage();
            // $this->data['memory_peak_usage'] = $this->dashboard_model->memory_peak_usage(TRUE);
            // $this->data['memory_usepercent'] = $this->dashboard_model->memory_usepercent(TRUE, FALSE);
			//~ echo "<pre>"; print_r($this->data); echo "</pre>"; exit;

            /* TEST */
            $this->data['url_exist']    = is_url_exist('http://www.domprojects.com');


            /* Load Template */
            $this->template->admin_render('admin/dashboard/index', $this->data);
        }
	}
}
