<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
 
// DB table to use
$table = 'kp_product_details';
 
// Table's primary key
$primaryKey = 'id';
 
// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case simple
// indexes
$columns = array(
    array( 'db' => 'product_id',  'dt' => 0 ),
    array(
            'db'        => 'image',
            'dt'        => 1,
            'formatter' => function( $d, $row ) {
                return "<img src='".$d."' width='80' height='80' >";
            }
    ),
    array( 'db' => 'product_title',  'dt' => 2 ),
    array( 'db' => 'sku',  'dt' => 3 ),
    array( 'db' => 'variant_skus',  'dt' => 4 ),

    array( 'db' => 'price_inr',  'dt' => 5 ),
    array( 'db' => 'price_usd',  'dt' => 6 ),
    array( 'db' => 'compare_at_price_inr',  'dt' => 7 ),
    array( 'db' => 'price_compare_at_usd',  'dt' => 8 ),


    array( 'db' => 'vendor',  'dt' => 9 ),
    /*array( 'db' => 'product_type',  'dt' => 9 ),*/
    /*array( 'db' => 'tags',   'dt' => 9 ),*/
    array( 'db' => 'created_at',  'dt' => 10 ),
    /*array( 'db' => 'updated_at',   'dt' => 11 ),*/
    array(
            'db'        => 'product_id',
            'dt'        => 11,
            'formatter' => function( $d, $row ) {
                return "<a href='/admin/orders/productedit/".$d."'>Edit</a>";
            }
    ),
     array(
            'db'        => 'product_id',
            'dt'        => 12,
            'formatter' => function( $d, $row ) {
                return "<a href='/admin/orders/productdelete/".$d."' >Delete</a>";
            }
    )
    
);
 
// SQL server connection information
$sql_details = array(
    'user' => 'pksqueak',
    'pass' => 'pk@admin$9',
    'db'   => 'pricecalc',
    'host' => 'localhost'
);
 
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
 
require( 'ssp.class.php' );
 
echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns )
);

?>
