<?php

class Functions_model extends CI_Model 
{
    function __construct()
    {
        // Call the Model constructor
        parent::__construct();
    }

    // Insert Table data
    function insert_ppo_data($data,$table_name='')
    {
		if($table_name == '')
		{
			echo "Table Name not found!";
			exit;
		}

        if($this->db->insert($table_name, $data))
		{ 
			if($this->db->insert_id())
			{
				return $this->db->insert_id();
			}
			else
			{
				return 1;
			}
		}
		else
		{
			return 0;
		}
    }

	// Get Table Data
	function get_ppo_data($data=0, $table_name='', $page=0, $per_page=0)
    {
		if($table_name == '')
		{
			echo "Table Name not found!";
			exit;
		}

		if($data != 0)
		{
			$this->db->where($data);
		}

		if($per_page != 0)
		{
			return $this->db->get($table_name, $per_page, $page);
		}
		else
		{
			return $this->db->get($table_name);
		}
    }

    function get_cth_auto_data($data=0, $table_name='', $page=0, $per_page=0, $like = array())
	{
		$this->db->select('item_name,CTH_HSN_Code');
		if($data != 0)
		{
			$this->db->where($data);
		}

		if(is_array($like) && count($like) > 0)
		{
			$this->db->like($like);
		}

		return $this->db->get($table_name);
	}

	// Delete Table Data
	function delete_ppo_data($data=0, $table_name='')
    {
		if($table_name == '')
		{
			echo "Table Name not found!";
			exit;
		}

		if($data != 0)
		{
			$this->db->delete($table_name, $data);
		}
		else
		{
			echo "Error";
			exit;	 
		} 
	}

	// Update Table Data
	function update_ppo_data($data1=0, $data2=0, $table_name='')
    {
		if($table_name == '')
		{
			echo "Table Name not found!";
			exit;
		}

		if($data1 != 0 && $data2 != 0)
		{
			$this->db->where($data1);
			$this->db->update($table_name, $data2);
			return 1;
		}
		else
		{
			echo "Error";
			exit;	 
		} 
	}

	// Get User Data - Join User and User Details Table
	function get_user_data($data=0, $page=0, $per_page=0)
    {
		$this->db->select('*');
		$this->db->from('users');

		$this->db->join('user_details', 'user_details.user_id = users.id');
		$this->db->join('address_book', 'address_book.user_id = users.id');

		if($data != 0)
		{
			$this->db->where($data);
		}

		$this->db->where('address_book.type',1);

		if($per_page != 0)
		{
			$this->db->limit($per_page, $page);
		}
		
		return $this->db->get();
		
    }

	// Get User Feedbacks - Join User Table
	function get_feedbacks($data=0, $page=0, $per_page=0)
    {
		$this->db->select('user_feedback.feedback_id, IFNULL(ppobox_id, user_feedback.user_ppono) AS ppobox_id, IFNULL(name, user_feedback.user_name) AS name, comment, user_feedback.time_created, user_feedback.approved', false);
		//$this->db->select('*');
		$this->db->from('user_feedback');

		$this->db->join('users', 'users.id = user_feedback.user_id', 'left');
		
		if($data != 0)
		{
			$this->db->where($data);
		}

		$this->db->where('user_feedback.approved',1);

		$this->db->order_by("user_feedback.time_created", "desc"); 

		if($per_page != 0)
		{
			$this->db->limit($per_page, $page);
		}
		
		return $this->db->get();
		
    }

    function insert_werehouse_data($data,$table_name='')
    {
		if($table_name == '')
		{
			echo "Table Name not found!";
			exit;
		}

        if($this->db->insert($table_name, $data))
		{ 
			if($this->db->insert_id())
			{
				return $this->db->insert_id();
			}
			else
			{
				return 1;
			}
		}
		else
		{
			return 0;
		}
    }

    function check_werehouse_details($data,$table_name='')
    {
		if($table_name == '')
		{
			echo "Table Name not found!";
			exit;
		}
		//print_r($data['sku']);
		$this->db->select('*');
		//print_r($query->num_rows());die;

		if(isset($data['sku']))
		{
			$this->db->where('sku',$data['sku']);
		}

		if(isset($data['id']))
		{
			$this->db->where('id',$data['id']);
		}
		$query = $this->db->get($table_name);
        if($query->num_rows() > 0)
		{ 
			return $query;
		}
		else
		{
			return 0;
		}
    }

    function update_warehouse_data($data,$table_name='',$id='')
    {
    	if($table_name == '')
    	{
    		echo "Table Name not found!";
    		exit;
    	}
    	//print_r($data);die;
    	$this->db->where('id', $id);
    	if($this->db->update($table_name, $data))
		{ 
			return TRUE;
		}
		else
		{
			return FALSE;
		}


    }

    public function get_werehouse_list($data,$id,$page = 0,$per_page = 0)
    {
    	$user_id = $data['user_id'];
    	$this->db->select('*')->where('user_id',$id);

    	if($data['searchTxt'])
    	{
            $arr = array('user_id','title','description','sku','barcode','ean','upc');


            foreach ($arr as $value) 
            {
            	$this->db->or_like($value,$data['searchTxt']);
            }

    	}

    	if($per_page != 0)
    	{
    	    $this->db->limit($per_page,$page);
    	}
    	$query = $this->db->order_by('created',desc)->get('werehouse');
    	//print_r($this->db->last_query());
    	return $query;
    }

    public function werehouse_edit_list($id)
    {
    	$query = "\n"
    . "(SELECT `werehouse`.`id`,`werehouse`.`title`, `werehouse`.`description`, `werehouse`.`sku`, `werehouse`.`qty`, `werehouse`.`price`, `werehouse`.`barcode`, `werehouse`.`ean`, `werehouse`.`upc`, `werehouse`.`created`, `werehouse_images`.`path` FROM (`werehouse`) LEFT JOIN `werehouse_images` ON `werehouse_images`.`werehouse_id` = `werehouse`.`id` WHERE `werehouse`.`id` = '$id')\n"
    . "UNION \n"
    . "(SELECT `werehouse`.`id`,`werehouse`.`title`, `werehouse`.`description`, `werehouse`.`sku`, `werehouse`.`qty`, `werehouse`.`price`, `werehouse`.`barcode`, `werehouse`.`ean`, `werehouse`.`upc`, `werehouse`.`created`, `werehouse_images`.`path` FROM (`werehouse`) RIGHT JOIN `werehouse_images` ON `werehouse_images`.`werehouse_id` = `werehouse`.`id` WHERE `werehouse_images`.`werehouse_id` = '$id')";
    	
    	return $this->db->query($query);
    }

    public function insert_shipment_history($data)
    {
    	foreach ($data as $value) {
    	    $insert_history = array(
    	        'shipment_id'=>$value['id'],
    	        'ppono'=>$value['ppono'],
    	        'shipment_status'=>$value['locked']
    	        );
    	    $this->db->insert('shipment_history',$insert_history);
    	}
    }
	function barcode_slip($id){
       $query = $query = $this->db->query("SELECT `shipment`.`id_var_copy`, `shipment`.`recepient_name`, `shipment`.`order_no`, `shipment`.`barcode`, `shipment`.`print_lable`, `users`.`logo`, `users`.`logo_title` FROM `shipment` INNER JOIN `users` on (`shipment`.`ppono` = `users`.`ppobox_id`) WHERE `shipment`.`id` = '".$id."'");
        $row = $query->result_array();
        return $row;
      // return $sql();
  
    }


}

?>
