<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

//error_reporting(E_ALL);ini_set('display_errors', 'on');
class Web extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();

        // Your own constructor code
        $this->load->model('functions_model');

        /* Block IP List Code Starts */

        $block_ip_list = $this->functions_model->get_ppo_data(0, 'blocked_ip')->result();

        $ip_list = array();

        foreach ($block_ip_list as $ip) {
            array_push($ip_list, $ip->key_word);
        }

        $my_ip = getenv('HTTP_CLIENT_IP') ?:
            getenv('HTTP_X_FORWARDED_FOR') ?:
                getenv('HTTP_X_FORWARDED') ?:
                    getenv('HTTP_FORWARDED_FOR') ?:
                        getenv('HTTP_FORWARDED') ?:
                            getenv('REMOTE_ADDR');

        if (in_array($my_ip, $ip_list)) {
            echo "Sorry, Your Ip has been blocked by admin!";
            exit;
        }

        /* Block IP List Code Ends */

        $ppo_cookie = $this->input->cookie('ppo_user_id');
        $ppo_session = $this->session->userdata('ppo_user_id');

        if ($ppo_session == '' && $ppo_cookie != '') {
            $newdata = array
            (
                'ppo_user_id' => $this->input->cookie('ppo_user_id'),
                'ppo_user_name' => $this->input->cookie('ppo_user_name')
            );

            $this->session->set_userdata($newdata);
        }
    }

    // Get Home Page
    public function index()
    {
        //echo 'in index page load';exit;
	$this->track_package();
    }

    // Get mailer update_address
    public function update_address()
    {
        $seodata = $this->config->item('SEO');
        $vdata['seo'] = $seodata['update_address'];

        $this->load->view('mailers/mailer_25-02-2016', $vdata);
    }

    // Contact Page
    public function contact($type = "contact")
    {
        if ($type == "contact") {
            $vdata['contact_type'] = "Contact Form";
        } else if ($type == "enquiry") {
            $vdata['contact_type'] = "Send an Enquiry";
        }

        $seodata = $this->config->item('SEO');
        $vdata['seo'] = $seodata['contact'];

        /* Code added from here to get logged in user name and email id, for populating while sending enquiry/contact us form */
        if (!empty($this->session->userdata('ppo_user_id')) && is_numeric($this->session->userdata('ppo_user_id'))) {
            $user = $this->functions_model->get_ppo_data(array('id' => $this->session->userdata('ppo_user_id')), 'users');

            $user = $user->row();

            $u_mail = $user->email;
            $u_name = $user->name;

            if (isset($u_name) && !empty($u_name) && $u_name != '') {
                $vdata['logged_in_u_email'] = $user->email;
                $vdata['logged_in_u_name'] = $user->name;
            }
            $vdata['input_readonly'] = 'true';
        } else {
            $vdata['input_readonly'] = 'false';
        }
        /* Code to retrieve user name and email id ends here */

        $this->form_validation->set_error_delimiters('<span class="error"><b></b>', '</span>');

        if ($this->input->server('REQUEST_METHOD') === 'POST') {
            if ($this->form_validation->run('contact') == FALSE) {
                $this->load->view('contact', $vdata);
            } else {
                $name = $this->input->post('first_name') . " " . $this->input->post('last_name');
                $email = $this->input->post('email');

                $mess = $this->input->post('message');
                /* Perform a check whether message is exceeding 500 characters or not */
                if (strlen($mess) > 500) {
                    $mess = substr($mess, 0, 500);
                }
                /* Code to check message length ends here */

                $phone = $this->input->post('code') . "-" . $this->input->post('phone');
                $prefer = $this->input->post('prefer');

                /* POSTED Details getting stored in contactus_enquiry table starts here */
                $inputData = array('enquirer_first_name' => $this->input->post('first_name'), 'enquirer_last_name' => $this->input->post('last_name'), 'enquirer_email' => $email, 'enquirer_phone' => $phone, 'enquiry_text' => $mess, 'preferred_contact' => $prefer, 'created' => date('Y-m-d H:i:s'));
                $this->db->insert('contactus_enquiry', $inputData);
                unset($inputData);
                /* POSTED Details getting stored in contactus_enquiry table ends here */

                $this->load->library('email');
                $this->load->library('parser');

                $smtp_settings = $this->config->item('smtp');

                $admin_email = $this->config->item('admin_forgot_email');
                $admin_name = $this->config->item('admin_forgot_name');

                $admin_contact = $this->config->item('admin_contact');

                $this->email->initialize($smtp_settings);

                $this->email->from($admin_email, $admin_name);

                $this->email->to('support@ppobox.com');        //$admin_contact
                $this->email->cc('sanjay@ppobox.com');

                if ($type == 'contact') {
                    $eml_subject = 'PPOBOX | Contact Us';
                } else if ($type == 'enquiry') {
                    $eml_subject = 'PPOBOX | Send an Enquiry';
                }
                $this->email->subject($eml_subject);
                unset($eml_subject);

                $message = "Hello Admin, Following user wants to contact you:<br>";
                $message .= "<b>Name:</b> $name,<br> <b>Email:</b> $email,<br><b>Phone:</b> $phone<br>";
                $message .= "<b>Preferred Contact:</b> $prefer,<br><b>Message:</b> $mess ";

                $site_link = $email_data['site_link'] = site_url();
                $logo_src = $email_data['logo_src'] = site_url() . "assets/images/pro_logo.png";

                $email_data['message'] = $message;

                $html_message = $this->load->view('email_templates/notification', $email_data, TRUE);
                $this->email->message($html_message);

                $this->email->send();

                $this->session->set_flashdata('success', 'Your information has been submitted successfully.');

                if ($type == "contact") {
                    $move_to = site_url() . "web/contact";
                } else if ($type == "enquiry") {
                    $move_to = site_url() . "web/contact/enquiry";
                }

                header("Location: $move_to");

            }
        } else {
            $this->load->view('contact', $vdata);
        }
    }

    // User Feedback Page
    public function user_feedback()
    {
        $ppo_session = $this->session->userdata('ppo_user_id');
        $fdbk_user_name = '';
        $fdbk_user_ppono = '';

        $seodata = $this->config->item('SEO');
        $vdata['seo'] = $seodata['user_feedback'];

        if ($ppo_session == '') {
            //$move_to = site_url() . "signup/login";

            //header("Location: $move_to");
            //exit;
            $user_id = 0;
        } else {
            $user_id = $this->session->userdata('ppo_user_id');

            $data = array('id' => $user_id);

            $user = $this->functions_model->get_ppo_data($data, 'users');

            $user = $user->row();

            $vdata['user'] = $user;
            $vdata['field_readonly'] = ' readonly="readonly" ';
        }

        $this->form_validation->set_error_delimiters('<span class="error"><b></b>', '</span>');


        if ($this->input->server('REQUEST_METHOD') === 'POST') {
            if ($this->form_validation->run('user_feedback') == FALSE) {
                $this->load->view('user_feedback', $vdata);
            } else {
                if (isset($user_id) && !empty($user_id) && $user_id != '') {
                    $fdbk_user_name = $user->name;
                    $fdbk_user_ppono = $user->ppobox_id;
                } else {
                    $fdbk_user_name = trim($this->input->post('name'));
                    $fdbk_user_ppono = trim($this->input->post('ppo_account'));
                }

                $data = array
                (
                    'user_id' => $user_id,
                    'user_name' => $fdbk_user_name,
                    'user_ppono' => $fdbk_user_ppono,
                    'comment' => $this->input->post("comment"),
                    'approved' => 0,
                    'ip_address' => $_SERVER['REMOTE_ADDR'],
                    'time_created' => date("Y-m-d H:i:s", time())
                );

                if ($this->functions_model->insert_ppo_data($data, 'user_feedback')) {
                    $str_MsgResult = 'Your feedback has been submitted successfully.<br>';
                    $str_MsgResult .= 'Your feedback is pending for approval.';
                    $this->session->set_flashdata('success', $str_MsgResult);

                    $move_to = site_url() . "web/user_feedback";

                    header("Location: $move_to");
                    exit;
                }
            }
        } else {
            $this->load->view('user_feedback', $vdata);
        }
    }

    // Check captcha code entered by user
    public function verification_check($str)
    {
        session_start();

        if ($_SESSION["captcha_code"] == $str) {
            return TRUE;
        } else {
            $this->form_validation->set_message('verification_check', '%s is wrong.');
            return FALSE;
        }
    }

    // Service page
    public function ppo_service()
    {
        $data = array('id' => 1);

        $vdata['content'] = $this->functions_model->get_ppo_data($data, 'content')->row();
        $this->load->view('header', $vdata);
        $this->load->view('content_page');
    }

    // Personal Service page
    public function personal_service()
    {
        $data = array('id' => 2);

        $vdata['content'] = $this->functions_model->get_ppo_data($data, 'content')->row();
        $this->load->view('header', $vdata);
        $this->load->view('content_page');
    }

    // find deal page
    public function find_deals()
    {
        $data = array('id' => 31);

        $vdata['content'] = $this->functions_model->get_ppo_data($data, 'content')->row();
        $this->load->view('header', $vdata);
        $this->load->view('content_page');
    }

    // Professional Service page
    public function professional_service()
    {
        $data = array('id' => 3);

        $vdata['content'] = $this->functions_model->get_ppo_data($data, 'content')->row();
        $this->load->view('header', $vdata);
        $this->load->view('content_page');
    }

    // How It Works page
    public function how_it_works()
    {
        $data = array('id' => 4);

        $vdata['content'] = $this->functions_model->get_ppo_data($data, 'content')->row();
        $this->load->view('header', $vdata);
        $this->load->view('content_page');
    }

    // How It Works page
    public function why_use_ppobox()
    {
        $data = array('id' => 5);

        $vdata['content'] = $this->functions_model->get_ppo_data($data, 'content')->row();
        $this->load->view('header', $vdata);
        $this->load->view('content_page');
    }


    // ppo points
    public function ppo_points()
    {
        $data = array('id' => 32);

        $vdata['content'] = $this->functions_model->get_ppo_data($data, 'content')->row();
        $this->load->view('header', $vdata);
        $this->load->view('content_page', $vdata);
    }

    // Rules and Regulations
    public function rules_and_regulations()
    {
        $data = array('id' => 6);

        $vdata['content'] = $this->functions_model->get_ppo_data($data, 'content')->row();
        $this->load->view('header', $vdata);
        $this->load->view('content_page');
    }

    // Personal Shipping
    public function personal_shipping()
    {
        $data = array('id' => 7);

        $vdata['content'] = $this->functions_model->get_ppo_data($data, 'content')->row();
        $this->load->view('header', $vdata);
        $this->load->view('content_page');
    }

    // Top US Shopping sites
    public function top_us_shopping_sites()
    {
        $data = array('id' => 8);

        $vdata['content'] = $this->functions_model->get_ppo_data($data, 'content')->row();
        $this->load->view('header', $vdata);
        $this->load->view('content_page');
    }

    // Top UK Shopping sites
    public function top_uk_shopping_sites()
    {
        $data = array('id' => 9);

        $vdata['content'] = $this->functions_model->get_ppo_data($data, 'content')->row();
        $this->load->view('header', $vdata);
        $this->load->view('content_page');
    }

    // Shopping Tips
    public function shopping_tips()
    {
        $data = array('id' => 10);

        $vdata['content'] = $this->functions_model->get_ppo_data($data, 'content')->row();
        $this->load->view('header', $vdata);
        $this->load->view('content_page');
    }

    // Transit Time
    public function transit_time()
    {
        $data = array('id' => 11);

        $vdata['content'] = $this->functions_model->get_ppo_data($data, 'content')->row();
        $this->load->view('header', $vdata);
        $this->load->view('content_page');
    }

    // Cost Estimator
    public function cost_estimator()
    {
        //$vdata['countries'] = $this->functions_model->get_ppo_data(0,'country');
        $seodata = $this->config->item('SEO');
        $vdata['seo'] = $seodata['cost_estimator'];
        $strQuery = 'SELECT * FROM `country` ORDER BY CASE `name` WHEN "India" THEN 1 ELSE 2 END ASC;';
        $vdata['countries'] = $this->db->query($strQuery);
        $vdata['items'] = $this->functions_model->get_ppo_data(array('active'=>1), 'shipment_items');

        $vdata['estimate_value'] = "";

        if ($this->input->server('REQUEST_METHOD') === 'POST') {
            if ($this->form_validation->run('cost_estimator') == FALSE) {
                $this->load->view('cost_estimator', $vdata);
            } else {
                $weight = $this->input->post("weight");

                $total_value_items = $this->input->post("total_value_items");

                /* Get Item Rate */
                $package_type = $this->input->post("package_type");

                $data = array('item_id' => $package_type,'active'=>1);
                $item = $this->functions_model->get_ppo_data($data, 'shipment_items');

                $item = $item->row();

                $item_rate = $item->item_rate;
                /* Get Item Rate Ends */

                if ($this->input->post('shipping_to') == "IND" || $this->input->post('shipping_to') == "USA") {
                    $estimate_value = 9 + (($weight - 1) * 5) + ($total_value_items * ($item_rate / 100));
                } else {
                    $estimate_value = 15 + (($weight - 1) * 10) + ($total_value_items * ($item_rate / 100));
                }

                $vdata['estimate_value'] = round($estimate_value, 2);

                $this->load->view('cost_estimator', $vdata);
            }
        } else {
            $this->load->view('cost_estimator', $vdata);
        }
    }

    // Duty Clearance
    public function duty_clearance()
    {
        $data = array('id' => 12);

        $vdata['content'] = $this->functions_model->get_ppo_data($data, 'content')->row();
        $this->load->view('header', $vdata);
        $this->load->view('content_page');
    }

    // Shipping Regulations
    public function shipping_regulations()
    {
        $data = array('id' => 13);

        $vdata['content'] = $this->functions_model->get_ppo_data($data, 'content')->row();
        $this->load->view('header', $vdata);
        $this->load->view('content_page');
    }

    // Unclaimed or Unpaid packages
    public function unclaimed_packages()
    {
        $data = array('id' => 14);

        $vdata['content'] = $this->functions_model->get_ppo_data($data, 'content')->row();
        $this->load->view('header', $vdata);
        $this->load->view('content_page');
    }

    // Shipping Electronics
    public function shipping_electronics()
    {
        $data = array('id' => 15);

        $vdata['content'] = $this->functions_model->get_ppo_data($data, 'content')->row();
        $this->load->view('header', $vdata);
        $this->load->view('content_page');
    }

    // Shipping Electronics
    public function resellers()
    {
        $data = array('id' => 16);

        $vdata['content'] = $this->functions_model->get_ppo_data($data, 'content')->row();
        $this->load->view('header', $vdata);
        $this->load->view('content_page');
    }

    // User Agreement
    public function user_agreement()
    {
        $data = array('id' => 17);

        $vdata['content'] = $this->functions_model->get_ppo_data($data, 'content')->row();
        $this->load->view('header', $vdata);
        $this->load->view('content_page');
    }

    // Insurance Policy
    public function insurance_policy()
    {
        $data = array('id' => 18);

        $vdata['content'] = $this->functions_model->get_ppo_data($data, 'content')->row();
        $this->load->view('header', $vdata);
        $this->load->view('content_page');
    }

    // Banned Items
    public function banned_items()
    {
        $data = array('id' => 19);

        $vdata['content'] = $this->functions_model->get_ppo_data($data, 'content')->row();
        $this->load->view('header', $vdata);
        $this->load->view('content_page');
    }

    // Refund Policy
    public function refund_policy()
    {
        $data = array('id' => 30);

        $vdata['content'] = $this->functions_model->get_ppo_data($data, 'content')->row();
        $this->load->view('header', $vdata);
        $this->load->view('content_page');
    }

    // About Us
    public function about_us()
    {
        $data = array('id' => 20);

        $vdata['content'] = $this->functions_model->get_ppo_data($data, 'content')->row();
        $this->load->view('header', $vdata);
        $this->load->view('content_page');
    }

    // FAQ
    public function faq()
    {
        $data = array('id' => 21);

        $vdata['content'] = $this->functions_model->get_ppo_data($data, 'content')->row();
        $this->load->view('header', $vdata);
        $this->load->view('content_page');
    }

    // Track Package
    public function track_package()
    {
        $seodata = $this->config->item('SEO');
        $view_data['seo'] = $seodata['track_package'];

        $view_data['page_number'] = 9;

        $view_data['errors'] = "";
        $view_data['package_status'] = "";
        $view_data['follow_status'] = "";
        $view_data['package_id'] = "";

        if ($this->input->server('REQUEST_METHOD') === 'POST') {
            $package_id = trim($this->input->post('package_id'));

            if (!isset($package_id) || empty($package_id) || $package_id == '')        //!is_numeric ( $package_id )
            {
                $view_data['errors'] = "Invalid Package Id";
            } else {

                $view_data['package_id'] = $package_id;

                // Get Details from Zoho Starts

                // Authorization token for the zoho crm account
                // $auth  = "f55d9073487f34a0af1a72ed91619dbc";
                $auth = "b296ae94226bd8484ec5ceff7b38ecfd";

                $url = "https://crm.zoho.com/crm/private/xml/Leads/searchRecords?authtoken=$auth&scope=crmapi&criteria=(((UNIQUE Package No.:$package_id)))";

                $xml = simplexml_load_file($url) or die("feed not loading");

                //echo "<pre>"; print_r($url); die;
                foreach ($xml as $key0 => $value) {
                    foreach ($value as $key => $value2) {
                        foreach ($value2 as $key2 => $value3) {
                            foreach ($value3 as $key3 => $value4) {

                                foreach ($value4->attributes() as $attributeskey3 => $attributesvalue4) {
                                    //echo "$attributeskey3 => $attributesvalue4" . "<br>";
                                    if ($attributesvalue4 == "Package Status") {
                                        $package_status = $value4;
                                    }

                                    if ($attributesvalue4 == "Follow-up Status") {
                                        $follow_status = $value4;
                                    }

                                }
                            }
                        }
                    }
                }
                //die;

                //echo $package_status; echo $follow_status; die;

                if (isset($package_status)) {
                    $view_data['package_status'] = $package_status;
                    $view_data['follow_status'] = $follow_status;
                } else {
                    $view_data['errors'] = "Sorry, No Updates yet.";
                }
            }
        }
        $data = array
        (
            'id' => $this->session->userdata('ppo_user_id')
        );
        
        $user = $this->functions_model->get_ppo_data($data, 'users');
        $view_data['user_data'] = $user->row();

        $this->load->view('track_package', $view_data);
    }

    public function track_your_package()
    {
        if($this->input->server('REQUEST_METHOD') === 'GET')
        {
            $txtawbno = trim($this->input->get('txtawbno'));
            $view_data['txtawbno'] = $txtawbno;
            if(empty($txtawbno))
            {
                $view_data['errors'] = 'Something wrong with Your tracking no. Please try Later.';
            }
        }

        $this->load->view('track_your_package', $view_data);
    }

    // View All Feedbacks
    public function all_feedbacks($page_id = 0)
    {
        if (!isset($page_id) || empty($page_id) || $page_id == '' || !is_numeric($page_id)) {
            $page_id = 0;
        }

        $seodata = $this->config->item('SEO');
        $vdata['seo'] = $seodata['all_feedbacks'];

        $this->load->library('pagination');
        $fdbk_config["per_page"] = 10;
        $fdbk_config["uri_segment"] = 3;

        $count = $this->functions_model->get_feedbacks(0, 0, 0);
        $count = $count->num_rows;
        $fdbk_config['total_rows'] = $count;
        $fdbk_config['base_url'] = site_url() . "web/all_feedbacks/";

        $fdbk_config['last_link'] = '&raquo;';
        $fdbk_config['first_link'] = '&laquo;';
        $fdbk_config['num_tag_open'] = '<li>';
        $fdbk_config['num_tag_close'] = '</li>';

        $fdbk_config['next_tag_open'] = '<li>';
        $fdbk_config['next_tag_close'] = '</li>';

        $fdbk_config['prev_tag_open'] = '<li>';
        $fdbk_config['prev_tag_close'] = '</li>';

        $fdbk_config['first_tag_open'] = '<li>';
        $fdbk_config['first_tag_close'] = '</li>';

        $fdbk_config['last_tag_open'] = '<li>';
        $fdbk_config['last_tag_close'] = '</li>';

        $fdbk_config['cur_tag_open'] = "<li><a class='active'>";
        $fdbk_config['cur_tag_close'] = '</a></li>';

        /*        $fdbk_config['first_link'] = "&lt;&lt;";
                $fdbk_config['last_link'] = "&gt;&gt;";*/

        $this->pagination->initialize($fdbk_config);

        $vdata['feedbacks'] = $this->functions_model->get_feedbacks(0, $page_id, 10);
        $vdata['links'] = $this->pagination->create_links();

        $this->load->view('all_feedbacks', $vdata);
    }

    // Disclaimer
    public function disclaimer()
    {
        $data = array('id' => 22);

        $vdata['content'] = $this->functions_model->get_ppo_data($data, 'content')->row();
        $this->load->view('header', $vdata);
        $this->load->view('content_page');
    }

    // Disclaimer
    public function privacy_policy()
    {
        $data = array('id' => 23);

        $vdata['content'] = $this->functions_model->get_ppo_data($data, 'content')->row();
        $this->load->view('header', $vdata);
        $this->load->view('content_page');
    }

    // KYC Registration
    public function kyc()
    {
        /* Code commented as the page will come as static page from 22-06-2015
        $data = array('id' => 24);

        $vdata['content'] = $this->functions_model->get_ppo_data($data,'content')->row();
         */
        $seodata = $this->config->item('SEO');
        $vdata['seo'] = $seodata['kyc'];
        $user = array();
        //if( isset($this->session->userdata('ppo_user_id')) )
        //{
        $user_id = $this->session->userdata('ppo_user_id');
        $data = array('users.id' => $user_id);
        $user = $this->functions_model->get_user_data($data, 'users');
        $user = $user->row();
        //}
        /* Below line is commented to add custom kyc registration page, to enable CMS based editable page, then remove the below comment */
        // $this->load->view('content_page',$vdata);
        //echo '<pre>';print_r($user);echo '</pre>';
        $this->load->view('view_kyc_registration', $vdata);
    }

    // Jot Form Professional and Corporate Link
    public function contact_service($page = 'professional')
    {
        $seodata = $this->config->item('SEO');
        $view_data['seo'] = $seodata['contact_service_professional'];
        if ($page == 'corporate') {
            $view_data['seo'] = $seodata['contact_service_corporate'];
        }
        $view_data['page'] = $page;
        $this->load->view('contact_service', $view_data);
    }

    // For Retailers
    public function retailers()
    {
        $data = array('id' => 25);

        $vdata['content'] = $this->functions_model->get_ppo_data($data, 'content')->row();
        $this->load->view('header', $vdata);
        $this->load->view('content_page');
    }

    // For Consumers
    public function consumers()
    {
        $data = array('id' => 26);

        $vdata['content'] = $this->functions_model->get_ppo_data($data, 'content')->row();
        $this->load->view('header', $vdata);
        $this->load->view('content_page');
    }

    // Compare Costs
    public function compare_costs()
    {
        $data = array('id' => 27);

        $vdata['content'] = $this->functions_model->get_ppo_data($data, 'content')->row();
        $this->load->view('header', $vdata);
        $this->load->view('content_page');
    }

    // Popular Stores
    public function popular_stores()    //make_stores()
    {
        $data = array('id' => 28);

        $vdata['content'] = $this->functions_model->get_ppo_data($data, 'content')->row();
        $this->load->view('header', $vdata);
        $this->load->view('content_page');
    }

    // Popular Stores
    public function make_payment()
    {
        $data = array('id' => 29);

        $vdata['content'] = $this->functions_model->get_ppo_data($data, 'content')->row();
        $seodata = $this->config->item('SEO');
        $vdata['seo'] = $seodata['make_payment'];
        $this->load->view('direct_make_payment', $vdata);
    }

    // Pay in Indian Rupees INR
    public function payment2()
    {
        $seodata = $this->config->item('SEO');
        $vdata['seo'] = $seodata['payment2'];
        $this->load->view('payment2', $vdata);
    }

    // Request an Ajax handler function
    public function requestAnAjax()
    {
        $txtCallType = trim($_POST['txtCallType']);
        $txtInputValue = trim($_POST['txtInputValue']);

        $strQuery = '';
        // Code starts here for type of request call checking
        switch ($txtCallType) {
            case 'countryToState':
                $strQuery = 'SELECT `state_name`, `state_name` FROM `state_list`, `country` ' .
                    'WHERE `country`.`iso_code_3` = ? AND `state_list`.`country_id` = `country`.`country_id`;';

                break;
        }
        // Code ends here for type of request call checking

        $arrResultSet = array();
        $actualResultSet = array();
        // Execute the query and get resutlset in arrResultSet variable starts here
        if (isset($strQuery) && !empty($strQuery)) {
            $arrResultSet = $this->db->query($strQuery, array($txtInputValue));
            if ($arrResultSet->num_rows() > 0) {
                foreach ($arrResultSet->result() as $row) {
                    switch ($txtCallType) {
                        case 'countryToState':
                            $actualResultSet[] = array('name' => $row->state_name, 'value' => $row->state_name);
                            break;
                    }
                }
            }
            $arrResultSet->free_result();
        }
        // Code to retrieve resultset from strQuery ends here
        echo json_encode(array(returnValue => $actualResultSet));
    }

    // Do Cost Estimation Depending on the parameters passed
    public function doCostEstimation()
    {
        $result_sp = 0;         // Result shipping price & clearance in dollar
        $result_sprs = 0;         // Result shipping price & clearance in INR
        $result_ct = 0;         // Result estimated custom charges in dollar
        $result_ctrs = 0;         // Result estimated custom charges in INR
        $result_totdoll = 0;         // Result total estimated in dollar
        $result_totrs = 0;         // Result total estimated in INR
        $result_stax = 0;         // Result service tax result in INR

        $posted_Data = $this->security->xss_clean($_POST);

        $txtAction = '';
        if (isset($posted_Data['txtAction']) && !empty($posted_Data['txtAction']) && $posted_Data['txtAction'] != '') {
            $txtAction = trim($_POST['txtAction']);
        }

        switch ($txtAction) {
            case 'doCostEstimate':
                // Retrieving of posted variables starts here
                $shipping_from = '';
                if (isset($posted_Data['shipping_from']) && !empty($posted_Data['shipping_from']) && $posted_Data['shipping_from'] != '') {
                    $shipping_from = trim($posted_Data['shipping_from']);
                }

                $shipping_to = '';
                if (isset($posted_Data['shipping_to']) && !empty($posted_Data['shipping_to']) && $posted_Data['shipping_to'] != '') {
                    $shipping_to = trim($posted_Data['shipping_to']);
                }

                $shipping_state = '';
                if (isset($posted_Data['shipping_state']) && !empty($posted_Data['shipping_state']) && $posted_Data['shipping_state'] != '') {
                    $shipping_state = trim($posted_Data['shipping_state']);
                }

                $indTousa_servicetype = '';
                if (isset($posted_Data['indTousa_servicetype']) && !empty($posted_Data['indTousa_servicetype']) && $posted_Data['indTousa_servicetype'] != '') {
                    $indTousa_servicetype = trim($posted_Data['indTousa_servicetype']);
                }

                $usaToother_servicetype = '';
                if (isset($posted_Data['usaToother_servicetype']) && !empty($posted_Data['usaToother_servicetype']) && $posted_Data['usaToother_servicetype'] != '') {
                    $usaToother_servicetype = trim($posted_Data['usaToother_servicetype']);
                }

                $indTousa_area = '';
                if (isset($posted_Data['indTousa_area']) && !empty($posted_Data['indTousa_area']) && $posted_Data['indTousa_area'] != '') {
                    $indTousa_area = trim($posted_Data['indTousa_area']);
                }

                $package_type = '';
                if (isset($posted_Data['package_type']) && !empty($posted_Data['package_type']) && $posted_Data['package_type'] != '') {
                    $package_type = trim($posted_Data['package_type']);
                }

                $item_category = 0;
                if (isset($posted_Data['item_category']) && !empty($posted_Data['item_category']) && $posted_Data['item_category'] != '') {
                    $item_category = trim($posted_Data['item_category']);
                }

                $total_value_items = 0;
                if (isset($posted_Data['total_value_items']) && !empty($posted_Data['total_value_items']) && $posted_Data['total_value_items'] != '') {
                    $total_value_items = trim($posted_Data['total_value_items']);
                }
                if (!is_numeric($total_value_items)) {
                    $total_value_items = 0;
                }
                $total_value_items = floatval($total_value_items);

                $actual_weight = 0;
                if (isset($posted_Data['weight']) && !empty($posted_Data['weight']) && $posted_Data['weight'] != '') {
                    $actual_weight = trim($posted_Data['weight']);
                }
                if (!is_numeric($actual_weight)) {
                    $actual_weight = 0;
                }
                $actual_weight = floatval($actual_weight);

                $length = 0;
                if (isset($posted_Data['length']) && !empty($posted_Data['length']) && $posted_Data['length'] != '') {
                    $length = trim($posted_Data['length']);
                }
                if (!is_numeric($length)) {
                    $length = 0;
                }
                $length = floatval($length);

                $width = 0;
                if (isset($posted_Data['width']) && !empty($posted_Data['width']) && $posted_Data['width'] != '') {
                    $width = trim($posted_Data['width']);
                }
                if (!is_numeric($width)) {
                    $width = 0;
                }
                $width = floatval($width);

                $height = 0;
                if (isset($posted_Data['height']) && !empty($posted_Data['height']) && $posted_Data['height'] != '') {
                    $height = trim($posted_Data['height']);
                }
                if (!is_numeric($height)) {
                    $height = 0;
                }
                $height = floatval($height);


                $IEC_code = yes;
                if (isset($posted_Data['IEC_code']) && !empty($posted_Data['IEC_code']) && $posted_Data['IEC_code'] != '') {
                    $IEC_code = trim($posted_Data['IEC_code']);
                }


                $item_rate = 0;
                // Retrieving of posted variables ends here

                /* Retrieval of item rate, for selected item category starts here */
                $strQuery = 'SELECT `item_rate` FROM `shipment_items` WHERE `item_id`=? LIMIT 0, 1;';

                $tempItemSet = array();
                $tempItemSet = $this->db->query($strQuery, array($item_category));
                if ($tempItemSet->num_rows() > 0) {
                    foreach ($tempItemSet->result() as $row) {
                        $item_rate = $row->item_rate;
                    }
                    unset($row);
                }
                $item_rate = floatval($item_rate);
                unset($tempItemSet);
                /* Retrieval of item rate, for selected item category ends here */

                /* Retrieval of the config field values start here */
                $strQuery = 'SELECT `old_id`, `id`, `field_name`, `field_value` FROM `config`;';

                $tempConfigSet = array();
                $arrConfigSet = array();
                $tempConfigSet = $this->db->query($strQuery);
                if ($tempConfigSet->num_rows() > 0) {
                    foreach ($tempConfigSet->result() as $row) {
                        $arrConfigSet[] = array('old_id' => $row->old_id, 'id' => $row->id, 'field_name' => $row->field_name, 'field_value' => $row->field_value);
                    }
                    unset($row);
                }
                unset($tempConfigSet);
                /* Retrieval of the config field values ends here */

                if (($shipping_from == 'USA' || $shipping_from == 'UK') && $shipping_to == 'IND') {
                    // Step1: Calculate the volumetric weight in KG's, then convert it into LBS.
                    // Formula: Volumetric_Weight in kg = ( length * width * height ) / 5000
                    // 1 KG = 2.2 LBS
                    $volumetric_weight = ($length * $width * $height) / 5000;
                    $volumetric_weight = floatval($volumetric_weight) * 2.2;

                    // Calculation will be done on Assessable Value from 02/03/2016 and not on Total Value of Items USD starts here
                    $freight_weight = max(array($volumetric_weight, $actual_weight));
                    $freight_charge1 = $total_value_items * (20 / 100);
                    $freight_charge2 = ($freight_weight / 2.2) * 3.4;
                    $freight_charge = floatval(min(array($freight_charge1, $freight_charge2)));

                    $insurance_charge = floatval($total_value_items) * (1.125 / 100);
                    $cif_value = floatval($freight_charge + $insurance_charge + $total_value_items);
                    $landing_charges = floatval($cif_value * (1 / 100));
                    $assessable_value = floatval($cif_value + $landing_charges);
                    $total_value_items = $assessable_value;
                    // Calculation will be done on Assessable Value from 02/03/2016 and not on Total Value of Items USD ends here

                    // Step2: Get difference between volumetric weight and actual weight
                    // Check whether its difference weight is greater than 2, then weight_to_consider = volumetric weight or else weight_to_consider = actual weight
                    $weight_difference = ($volumetric_weight - $actual_weight);

                    // As while performing calculation, shipping charge is different for 1st LBS and different for more than 1 LBS.
                    $extra_shipping_weight = ($actual_weight - 1);  // Get extra weight which is more than 1 LBS.

                    // Step3: Retrieve Shipping Charge for From Country to To Country
                    // Shipping Charge for 1st LBS quantity
                    $shipping_charge = 0;                   // Default shipping charge
                    $shipping_charge_for_1st_lbs = 0;       // Default shipping charge for 1st lbs
                    $exchange_rate = 0;                     // Default exchange rate for market USA
                    $exchange_rate_euro = 0;                // Default exchange rate for market UK
                    $service_tax = 0;                       // Default Service Tax

                    if (is_array($arrConfigSet) && count($arrConfigSet) > 0) {
                        foreach ($arrConfigSet as $tempConfigRow) {
                            switch ($tempConfigRow['field_name']) {
                                case 'Shipping Charge from US to India upto 1 lbs':
                                    $shipping_charge = floatval($tempConfigRow['field_value']);
                                    break;
                                case 'Shipping Charge from US to India if more than 1 lbs':
                                    $shipping_charge_for_1st_lbs = floatval($tempConfigRow['field_value']);
                                    break;
                                case 'USD to INR conversion rate':
                                    $exchange_rate = floatval($tempConfigRow['field_value']);
                                    break;
                                case 'Euro to INR conversion rate':
                                    $exchange_rate_euro = floatval($tempConfigRow['field_value']);
                                    break;
                                case 'service_tax':
                                    $service_tax = floatval($tempConfigRow['field_value']) / 100;
                                    break;
                                case 'default_duty_charges':
                                $default_duty_charges = floatval($tempConfigRow['field_value']);
                                    break;
                            }
                        }
                        unset($tempConfigRow);
                    }
                    if($IEC_code == 'no')
                    {
                        $item_rate = $default_duty_charges;
                    }

                    // changing exchange rate for market USA & UK, from 02/03/2016 starts here
                    switch ($shipping_from) {
                        case 'UK':
                            $exchange_rate = $exchange_rate_euro;
                            break;
                    }
                    // changing exchange rate for market USa & UK, ends here

                    $shipping_charge = floatval($shipping_charge);
                    $shipping_charge_for_1st_lbs = floatval($shipping_charge_for_1st_lbs);

                    // Calcualte the price, according to item category for entered number of items
                    $ctdollexact = (($total_value_items * $item_rate) / 100);

                    if ($weight_difference > 2) {
                        //$weight_to_consider = $volumetric_weight;
                        // 0.15 is added as an service fees on duty amount
                        if ($actual_weight >= 1) {
                            $spdoll = ($weight_difference * 3) + $shipping_charge + ($extra_shipping_weight * $shipping_charge_for_1st_lbs) + (0.15 * $ctdollexact);
                        } elseif ($actual_weight < 1) {
                            $spdoll = 6 + (($actual_weight + ($weight_difference * 0.7) - 1) * $exchange_rate) + (0.15 * $ctdollexact);
                        } else {
                            $spdoll = $shipping_charge + (($actual_weight + ($weight_difference * 0.7) - 1) * $exchange_rate) + (0.15 * $ctdollexact);
                        }
                    } else {
                        //$weight_to_consider = $actual_weight;
                        // 0.15 is added as an service fees on duty amount
                        if ($actual_weight >= 1) {
                            $spdoll = $shipping_charge + ($extra_shipping_weight * $shipping_charge_for_1st_lbs) + (0.15 * $ctdollexact);
                        } elseif ($actual_weight < 1) {
                            $spdoll = 6 + (0.15 * $ctdollexact);
                        } else {
                            $spdoll = $shipping_charge + (0.15 * $ctdollexact);
                        }
                    }

                    $sprs = floatval($spdoll) * $exchange_rate;
                    $ctdoll = number_format($ctdollexact, 2, '.', '');
                    $ctrs = ceil($ctdoll * $exchange_rate);
                    $servicetaxperc = number_format($service_tax * $sprs, 2, '.', '');

                    $totdoll = number_format(floatval($spdoll) + floatval($ctdoll), 2, '.', '');
                    $totrs = floatval($sprs) + floatval($ctrs) + $servicetaxperc;
                    $totrs = number_format($totrs, 2, '.', '');

                    // Assigning of result variables starts here
                    $result_sp = $spdoll;
                    $result_sprs = $sprs;
                    $result_ct = $ctdoll;
                    $result_ctrs = $ctrs;
                    $result_totdoll = $totdoll;
                    $result_totrs = $totrs;
                    $result_stax = $servicetaxperc;
                    // Assigning of result variables ends here

                    // Removing of variable details which were used starts here
                    $tempItem_rate = $item_rate;
                    unset($shipping_from);
                    unset($shipping_to);
                    unset($shipping_state);
                    unset($indTousa_servicetype);
                    unset($usaToother_servicetype);
                    unset($indTousa_area);
                    unset($package_type);
                    unset($item_category);
                    unset($total_value_items);
                    unset($actual_weight);
                    unset($length);
                    unset($width);
                    unset($height);
                    unset($volumetric_weight);
                    unset($weight_difference);
                    unset($weight_to_consider);
                    unset($item_rate);
                    unset($arrConfigSet);
                    unset($shipping_charge_for_1st_lbs);
                    unset($shipping_charge);
                    unset($ctdollexact);
                    unset($extra_shipping_weight);
                    unset($sprs);
                    unset($ctdoll);
                    unset($ctrs);
                    unset($servicetaxperc);
                    unset($service_tax);
                    unset($totdoll);
                    unset($totrs);
                    // Removing of variables details which were used ends here
                } elseif ($shipping_from == 'IND') {
                    $remote_ResidentialCharges_rs = 0;
                    switch ($indTousa_area) {
                        case 1:
                            $remote_ResidentialCharges_rs = 150;
                            break;
                    }

                    // Step1: Retrieve Shipping Charge for From Country to To Country
                    // Shipping Charge for 1st LBS quantity
                    $first_500_grms = 0;                    // Default value for ny 1st 500 grams
                    $add_500_grms = 0;                      // Default value for ny addn 500 grams
                    $more_than_11_kgs = 0;                  // Default value for ny more than 11 kgs per kg
                    $std_service_1st_500_grms = 0;          // Default value for standard service 1st 500 grams
                    $std_service_addn_500_grms = 0;         // Default value for standard service addn 500 grams
                    $exchange_rate = 0;                     // Default exchange rate
                    $service_tax = 0;                       // Default Service Tax

                    if (is_array($arrConfigSet) && count($arrConfigSet) > 0) {
                        foreach ($arrConfigSet as $tempConfigRow) {
                            switch ($tempConfigRow['field_name']) {
                                case 'ny 1st 500 gms':
                                    $first_500_grms = floatval($tempConfigRow['field_value']);
                                    break;
                                case 'ny addn 500 gms':
                                    $add_500_grms = floatval($tempConfigRow['field_value']);
                                    break;
                                case 'ny more than 11 kgs per kg':
                                    $more_than_11_kgs = floatval($tempConfigRow['field_value']);
                                    break;
                                case 'standard service 1st 500 gms':
                                    $std_service_1st_500_grms = floatval($tempConfigRow['field_value']);
                                    break;
                                case 'standard service addn 500 gms':
                                    $std_service_addn_500_grms = floatval($tempConfigRow['field_value']);
                                    break;
                                case 'USD to INR conversion rate':
                                    $exchange_rate = floatval($tempConfigRow['field_value']);
                                    break;
                                case 'service_tax':
                                    $service_tax = floatval($tempConfigRow['field_value']) / 100;
                                    break;
                                case 'default_duty_charges':
                                $default_duty_charges = floatval($tempConfigRow['field_value']) / 100;
                                    break;
                            }
                        }
                        unset($tempConfigRow);
                    }

                    if($IEC_code == 'no')
                    {
                        $item_rate = $default_duty_charges;
                    }

                    switch ($shipping_to) {
                        case "New York":
                            if ($actual_weight <= 0.5) {
                                $shipping_charge = $first_500_grms;
                                $fc = ($shipping_charge * 0.21);
                                $st = ($shipping_charge * $service_tax);
                                $sp = ($shipping_charge + $fc + $remote_ResidentialCharges_rs);
                                $bp = $total_value_items;
                                $ct = ($bp * $item_rate) / 100;
                                $totrs = $sp + $ct;
                            } elseif ($actual_weight > 0.5 && $actual_weight <= 11) {
                                $extra_shipping_weight = $actual_weight - 0.5;
                                $shipping_charge = $first_500_grms + ceil($extra_shipping_weight / 0.5) * $add_500_grms;
                            }
                            unset($fc);
                            unset($st);
                            unset($sp);
                            unset($bp);
                            unset($ct);
                            unset($totrs);
                            break;
                        default:
                            switch ($indTousa_servicetype) {
                                case 1:
                                    break;
                                case 2:
                                    break;
                                case 3:
                                    break;
                            }
                            break;
                    }

                    // Removing of variables details which were used starts here
                    unset($remote_ResidentialCharges_rs);
                    unset($exchange_rate);
                    unset($service_tax);
                    unset($first_500_grms);
                    unset($add_500_grms);
                    unset($more_than_11_kgs);
                    unset($std_service_1st_500_grms);
                    unset($std_service_addn_500_grms);
                    unset($shipping_charge);
                    // Removing of variables details which were used ends here
                }

                break;
        }

        unset($txtAction);

        echo json_encode(array("spdoll" => $result_sp, "sprs" => $result_sprs, "ctdoll" => $result_ct, "ctrs" => $result_ctrs, "totdoll" => $result_totdoll,
            "totrs" => $result_totrs, "stax" => $result_stax, 'item_rate' => $tempItem_rate));
    }

    // Thank you message redirection for various events.
    public function thankyou($processname = null, $processtype = null)
    {
        $view_data['process'] = $processname;
        switch ($processname) {
            case 'register':
                $user_id = $this->session->userdata('ppo_user_id');
                if (isset($user_id)) {
                    $data = array
                    (
                        'users.id' => $this->session->userdata('ppo_user_id')
                    );

                    $user = $this->functions_model->get_user_data($data);
                    $user = $user->row();

                    // $user_kyc = $user->kyc_document;

                    /* parameters to send in admin email */
                    // $u_name   = $user->name;
                    $u_email = $user->email;
                    // $u_ppo_id = $user->ppobox_id;
                    /* parameters to send in admin email */
                    $view_data['registered_emailid'] = $u_email;
                    $view_data['user_type'] = $u_email;
                }
                $view_data['register_type'] = $processtype;
        }
        $this->load->view('thank-you', $view_data);
    }

    /* function for popup show ajax call */
    public function address_info_flag()
    {
        $user_id = $this->session->userdata('ppo_user_id');
        $data = array
        (
            'id' => $user_id
        );

        $user = $this->functions_model->get_ppo_data($data, 'users');
        $user = $user->row();

        $popup_data['user_email'] = $user->email;
        $popup_data['user_ppono'] = $user->ppobox_id;
        $popup_data['user_id'] = $user_id;
        $popup_data['popup_confirm'] = 1;
        $popup_data['created_date'] = date('Y-m-d h:i:s', time());
        $this->db->insert('ppo_popup_log', $popup_data);
        if ($this->input->set_cookie('popupflag', 'true', 3600)) {
            echo 1;
        } else {
            echo 0;
        }

        //echo $this->db->affected_rows();
    }

    // Confirm popup_subscribe for user
    public function popup_subscribe()
    {
        $flag_error = 0;
        $pb_DlgName = trim($this->input->post('pb_DlgName'));
        $pb_DlgEmail = trim($this->input->post('pb_DlgEmail'));
        $pb_DlgPhone = trim($this->input->post('pb_DlgPhone'));

        if (!isset($pb_DlgName) || empty($pb_DlgName)) {
            $flag_error = 1;
        }

        if (!isset($pb_DlgEmail) || empty($pb_DlgEmail) || !filter_var($pb_DlgEmail, FILTER_VALIDATE_EMAIL)) {
            $flag_error = 1;
        }

        if (!isset($pb_DlgPhone) || empty($pb_DlgPhone) || !is_numeric($pb_DlgPhone)) {
            $flag_error = 1;
        }

        $txtReturnValue = 0;
        if ($flag_error == 0) {
            $known_subscribers_count = 0;
            $new_subscriber_query = "SELECT `id`, NOW() FROM `popup_subscription` WHERE `customer_email` = ?;";
            $arrResultSet = $this->db->query($new_subscriber_query, array($pb_DlgEmail));
            if ($arrResultSet->num_rows() > 0) {
                $known_subscribers_count = $arrResultSet->num_rows();
            }
            $arrResultSet->free_result();

            if ($known_subscribers_count == 0) {
                $arr_insertData = array('customer_name' => $pb_DlgName,
                    'customer_email' => $pb_DlgEmail,
                    'customer_phone' => $pb_DlgPhone,
                    'subscription_type' => 'registration',
                    'created' => date('Y-m-d H:i:s'));
                $inserted_id = $this->db->insert('popup_subscription', $arr_insertData);
                if (isset($inserted_id) && !empty($inserted_id)) {
                    $txtReturnValue = 1;
                    $email = 'ppobox.com@gmail.com';

                    $this->load->library('email');
                    $this->load->library('parser');

                    $smtp_settings = $this->config->item('smtp');

                    $admin_email = $this->config->item('admin_register_email');
                    $admin_name = $this->config->item('admin_register_name');

                    $this->email->initialize($smtp_settings);

                    $this->email->from($admin_email, $admin_name);

                    $this->email->to($email);
                    $this->email->cc('sanjay@ppobox.com,support@ppobox.com');//

                    $this->email->subject('PPOBOX - Popup Subscription Notification');

                    $site_link = $email_data['site_link'] = site_url();
                    $logo_src = $email_data['logo_src'] = site_url() . "assets/images/pro_logo.png";
                    $msg_name = $email_data['customer_name'] = $pb_DlgName;
                    $msg_gender = $email_data['customer_email'] = $pb_DlgEmail;
                    $msg_location = $email_data['customer_phone'] = $pb_DlgPhone;
                    $email_data['email'] = $email;

                    $html_message = $this->load->view('email_templates/popup_subscription', $email_data, TRUE);

                    $this->email->message($html_message);

                    $this->email->send();
                }
            } else {
                $txtReturnValue = 2;
            }
        }
        echo json_encode(array('returnValue' => $txtReturnValue));
    }

    public function maintenance_mode()
    {
        $this->load->view('maintenance_mode');
    }

    public function category_details()
    {
        $active_items = array('active'=>1);
        $items = $this->functions_model->get_ppo_data($active_items, 'shipment_items');
        $vdata['items'] = $items->result_array();
        $this->load->view('CTH_HSN_Code', $vdata);
    }
}
